package io.renren.modules.app.service.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.MxzDao;
import io.renren.modules.app.entity.HPzEntity2;
import io.renren.modules.app.entity.MxzEntity;
import io.renren.modules.app.entity.RjzEntity;
import io.renren.modules.app.service.MxzService;
import io.renren.modules.app.utils.MoneyUtil;

@Service("mxzService")
public class MxzServiceImpl extends ServiceImpl<MxzDao, MxzEntity> implements MxzService {

    // 明细账查询
    @Override
    public List<MxzEntity> mxzSelectByPage(MxzEntity mxzEntity) throws Exception {
        //定义返回集合
        List<MxzEntity> returnlist = new ArrayList<MxzEntity>();
        double ye = 0.0;
        List<MxzEntity> list = new ArrayList<MxzEntity>();
        if (mxzEntity.getSfjz().equals("1")) {
            list = baseMapper.mxzSelect_1(mxzEntity);
            if (list.size() > 0) {
                if (list.get(0).getKmsx().equals("0")) {
                    list.get(0).setKmsxmc("借方");
                } else {
                    list.get(0).setKmsxmc("贷方");
                }
            }
            //累计
            for (int i = 0; i < list.size(); i++) {
                if (i == 0) {
                    ye = Double.parseDouble(list.get(i).getQcye());
                    continue;
                }
                double tmpJFJE = list.get(i).getJfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getJfje());
                double tmpDFJE = list.get(i).getDfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getDfje());

                if (list.get(i).getKmsx().equals("0")) {
                    ye = ye + tmpJFJE - tmpDFJE;

                    // 保留两位小数四舍五入
                    BigDecimal b = new BigDecimal(ye);
                    double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

                    DecimalFormat df = new DecimalFormat("0.00");// 格式化
                    String qcye = df.format(f1);

                    list.get(i).setKmsxmc("借方");
                    list.get(i).setQcye(qcye);
                } else {
                    ye = ye - tmpJFJE + tmpDFJE;

                    // 保留两位小数四舍五入
                    BigDecimal b = new BigDecimal(ye);
                    double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

                    DecimalFormat df = new DecimalFormat("0.00");// 格式化
                    String qcye = df.format(f1);

                    list.get(i).setKmsxmc("贷方");
                    list.get(i).setQcye(qcye);
                }
            }
            //本月借贷方金额
            Double monthJFJE = 0.0;
            Double monthDFJE = 0.0;
            //判断不同月
            String tmpKJQJ = list.get(0).getKjqj().substring(0, 7);
            //returnlist.add(list.get(0));
            for (int i = 0; i < list.size(); i++) {
                String tmpKJQJ2 = list.get(i).getKjqj().substring(0, 7);
                if (!tmpKJQJ.equals(tmpKJQJ2)) {
                    //定义对象
                    MxzEntity mxzentitytwo = new MxzEntity();
                    mxzentitytwo.setZymc("本月合计");
                    mxzentitytwo.setJfje(monthJFJE.toString());
                    mxzentitytwo.setDfje(monthDFJE.toString());
                    returnlist.add(mxzentitytwo);
                    monthJFJE = 0.0;
                    monthDFJE = 0.0;
                    tmpKJQJ = tmpKJQJ2;
                }
                returnlist.add(list.get(i));
                monthJFJE += list.get(i).getJfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getJfje());
                monthDFJE += list.get(i).getDfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getDfje());
            }
            //定义对象
            MxzEntity mxzentitysan = new MxzEntity();
            mxzentitysan.setZymc("本月合计");
            mxzentitysan.setJfje(monthJFJE.toString());
            mxzentitysan.setDfje(monthDFJE.toString());
            returnlist.add(mxzentitysan);
        } else {
            list = baseMapper.mxzSelect_2(mxzEntity);
            if (list.size() > 0) {
                if (list.get(0).getKmsx().equals("0")) {
                    list.get(0).setKmsxmc("借方");
                } else {
                    list.get(0).setKmsxmc("贷方");
                }
            }
            //累计借贷方金额
            for (int i = 0; i < list.size(); i++) {
                if (i == 1) {
                    ye = Double.parseDouble(list.get(i).getQcye());
                    continue;
                }
                double tmpJFJE = list.get(i).getJfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getJfje());
                double tmpDFJE = list.get(i).getDfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getDfje());

                if (list.get(i).getKmsx().equals("0")) {
                    ye = ye + tmpJFJE - tmpDFJE;

                    // 保留两位小数四舍五入
                    BigDecimal b = new BigDecimal(ye);
                    double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

                    DecimalFormat df = new DecimalFormat("0.00");// 格式化
                    String qcye = df.format(f1);

                    list.get(i).setKmsxmc("借方");
                    list.get(i).setQcye(qcye);
                } else {
                    ye = ye - tmpJFJE + tmpDFJE;

                    // 保留两位小数四舍五入
                    BigDecimal b = new BigDecimal(ye);
                    double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

                    DecimalFormat df = new DecimalFormat("0.00");// 格式化
                    String qcye = df.format(f1);

                    list.get(i).setKmsxmc("贷方");
                    list.get(i).setQcye(qcye);
                }

            }
            //本月借贷方金额
            Double monthJFJE = 0.0;
            Double monthDFJE = 0.0;
            //判断不同月
            String tmpKJQJ = list.get(0).getKjqj().substring(0, 7);
            //returnlist.add(list.get(0));
            for (int i = 0; i < list.size(); i++) {
                String tmpPZRQ = list.get(i).getKjqj().substring(0, 7);
                if (!tmpKJQJ.equals(tmpPZRQ)) {
                    //定义对象
                    MxzEntity mxzentitytwo = new MxzEntity();
                    mxzentitytwo.setZymc("本月合计");
                    mxzentitytwo.setJfje(monthJFJE.toString());
                    mxzentitytwo.setDfje(monthDFJE.toString());
                    returnlist.add(mxzentitytwo);
                    monthJFJE = 0.0;
                    monthDFJE = 0.0;
                    tmpKJQJ = tmpPZRQ;
                }
                returnlist.add(list.get(i));
                monthJFJE += list.get(i).getJfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getJfje());
                monthDFJE += list.get(i).getDfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getDfje());
            }
            MxzEntity mxzentitysan = new MxzEntity();
            mxzentitysan.setZymc("本月合计");
            mxzentitysan.setJfje(monthJFJE.toString());
            mxzentitysan.setDfje(monthDFJE.toString());
            returnlist.add(mxzentitysan);
        }

        return returnlist;
    }


    public String getKmmc(String kmdm, String kmjb, String ztbm) {
        String kmmc = "";
        String kmjb1 = "";
        String _full_kmmc = "";
        String skmdm = "";
        int len = 0;
        int len3 = 0;

        if (kmjb == null) {
            return kmmc;
        }
        len3 = 1;
        len = 0;


        while (len3 <= kmjb.length() && len < kmdm.length()) {
            kmjb1 = baseMapper.select_kmjb2(kmjb, len3 + "");
            len = len + Integer.parseInt(kmjb1);
            if("0003".equals(ztbm)){
            	 if(len==9){
                 	len=len-1;
                 }
            }
            if (skmdm != kmdm.trim().substring(1, len)) {
            	if("0003".equals(ztbm)&&len==3){
            		len=len+1;
            		kmmc = baseMapper.select_kmmc(ztbm, kmdm, len);
            		len=len-1;
            	}else if("0003".equals(ztbm)&&len==6){
            		kmmc = baseMapper.select_kmmc(ztbm, kmdm, len);
            	}else{
            		kmmc = baseMapper.select_kmmc(ztbm, kmdm, len);
            	}
                skmdm = kmdm.trim().substring(1, len);
                _full_kmmc = _full_kmmc + kmmc + "-";
            }
            if(kmdm.length()==4){
            	break;
            }
            len3 = len3 + 1;
        }

        _full_kmmc = _full_kmmc.substring(0, _full_kmmc.length() - 1);

        return _full_kmmc;

    }

    //查询凭证记录
    @Override
    public List<HPzEntity2> select_pz(HPzEntity2 hPzEntity2) {
        String kmdmmc = "";
        String km = "";
        Double df = 0.0;
        Double jf = 0.0;
        HPzEntity2 hPzEntity = new HPzEntity2();
//        String kmjb = baseMapper.select_kmjb(hPzEntity2.getZtbm());
        List<HPzEntity2> list = baseMapper.select_pz(hPzEntity2);
        for (int i = 0; i < list.size(); i++) {
            df = df + list.get(i).getDfje();
            jf = jf + list.get(i).getJfje();
            list.get(i).setZdfje(df.toString());
            list.get(i).setZjfje(jf.toString());
            km = list.get(i).getKm();
            kmdmmc = getKmmc(km, "333", hPzEntity2.getZtbm());
            list.get(i).setKmdmmc(kmdmmc);
        }

        if ("0.0".equals(df)) {

        } else {
            hPzEntity.setJedx(MoneyUtil.toChinese(String.valueOf(df.longValue()).toString()));
        }
        hPzEntity.setZdfje(df.toString());
        hPzEntity.setZjfje(jf.toString());
        list.add(hPzEntity);
        return list;
    }

}
