package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.SfdwDao;
import io.renren.modules.app.entity.SfdwEntity;
import io.renren.modules.app.entity.SfdwEntity2;
import io.renren.modules.app.service.SfdwService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("sfdwService")
public class SfdwServiceImpl extends ServiceImpl<SfdwDao, SfdwEntity> implements SfdwService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param sfdwEntity
     * @return
     */
    @Override
    public PageInfo<SfdwEntity2> queryByPage(Integer pageNum, Integer pageSize, SfdwEntity2 sfdwEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<SfdwEntity2> sfdwEntitys = baseMapper.queryByPage(sfdwEntity);
        PageInfo<SfdwEntity2> pageInfo = new PageInfo<SfdwEntity2>(sfdwEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }

	@Override
	public String querydwbm() {
		
		return baseMapper.querydwbm();
	}


}