package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchWorkQueueException;

import io.renren.modules.app.dao.WxzjyjfhDao;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.HKmEntity;
import io.renren.modules.app.entity.SfdwEntity;
import io.renren.modules.app.entity.SqwxzqEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XmEntity;
import io.renren.modules.app.entity.XzdyFwxxSdEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzTempEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.WxzjyjfhService;
import javassist.bytecode.stackmap.BasicBlock.Catch;
import net.bytebuddy.asm.Advice.This;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.w3c.dom.ls.LSInput;

@Service("wxzjyjfhService")
public class WxzjyjfhServiceImpl extends ServiceImpl<WxzjyjfhDao, XzdyFwxxSdEntity> implements WxzjyjfhService {

	@Override
	public List<XlkEntity> selectxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			list = baseMapper.selectdw();
		} else if ("mhdw".equals(map.get("MHDW"))) {
			list = baseMapper.selectmhdw(map.get("mhdwz"));
		} else if ("mhxq".equals(map.get("MHXQ"))) {
			list = baseMapper.selectxlkxq(map.get("pt"));
		} else if ("jsfs".equals(map.get("JSFS"))) {
			list = baseMapper.selectjsfs();
		} else if ("skyh".equals(map.get("SKYH"))) {
			list = baseMapper.selectyhxx();
		} else if ("kmlb".equals(map.get("KMLB"))) {
			list = baseMapper.selecthskm();
		}
		return list;

	}

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param ywpzEntity
	 * @return
	 */
	@Override
	public PageInfo<YwpzEntity> queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPage(ywpzEntity);

		for (int i = 0; i < ywpzEntitys.size(); i++) {
			List<YwpzEntity> y2 = baseMapper.selectyjmxyw(ywpzEntitys.get(i).getDjbh());
			List<String> listz = new ArrayList<String>();
			for (int j = 0; j < y2.size(); j++) {
				ZhxxEntity z = baseMapper.selectzhxx(y2.get(j).getDhbm());
				listz.add(z.getSffp());
			}
			boolean x = listz.contains("1");
			if (x == true) {
				ywpzEntitys.get(i).setSffp("1");
			} else if (x == false) {
				ywpzEntitys.get(i).setSffp("0");
			}
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	@Override
	public YwpzEntity selectCX(Map<String, String> map) {

		return baseMapper.selectck(map);
	}

	// 复核按钮
	@Override
	public void updateFH(List<DhbmyjEntity> dhyjs) {

		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);

		for (DhbmyjEntity d : dhyjs) {
			// 查询该单据的复核状态
			d.setShrq(temp_str);
			YwpzEntity ywpz = baseMapper.selectfhzt(d.getDjbh());
			if ("1".equals(ywpz.getShzt())) {
				// 则已审核，无需再审核
			} else if ("0".equals(ywpz.getShzt())) {
				// 则未审核，进行审核
				baseMapper.updatefhzt(d);
				// 向该开发商sfdw表中记录所缴金额zckje（此金额为未分配金额）
				SfdwEntity sfdwEntity = baseMapper.selectdwxx(ywpz.getDwbm());
				sfdwEntity.setZckje(sfdwEntity.getZckje() + ywpz.getJe());
				baseMapper.updatedwzckje(sfdwEntity);
				// 1.根据该单据编号查询yjmx表
				List<DhbmyjEntity> mxs = baseMapper.selectyjmx(d.getDjbh());
				// 2.根据查询的dhbm查询对应的zhxx，遍历
				for (DhbmyjEntity mx : mxs) {
					ZhxxEntity z = baseMapper.selectzhxx(mx.getDhbm());
					z.setDwze(z.getDwze() + mx.getJe());
					baseMapper.updatezhxx(z);
					// 应该每次复核一个单据，都要检测该单据预交的楼幢应缴金额和已交金额大小，
					// 如果此时相等则改变楼幢的sfdz为已交清，若应缴金额任然大于已交金额，则sfdz为未交清
					ZhxxEntity z2 = baseMapper.selectzhxx(mx.getDhbm());
					
					Double dwze = z2.getDwze();

					Double c=dwze-z2.getYjje();
					if(c>=-100&&c<=100){
						baseMapper.updatezhsfdz(z2);// sfdz=1
					}else{
						baseMapper.updatezhsfdz2(z2);// sfdz=0
					}

				}

			}
			
			//单位预交审核时将该单据记录在辅助核算明细表中
			List<YwpzEntity> y1s=baseMapper.selectfzhsdj(d.getDjbh());
			//----------------------------------------------------------------
			List<YwpzEntity> yxqs = baseMapper.selectzyxqmc(d.getDjbh());
			List<YwpzEntity> yxms = baseMapper.selectzyxmmc(d.getDjbh());
			List<YwpzEntity> ydhs = baseMapper.selectzydhmc(d.getDjbh());
			String xq = "";
			String xm = "";
			String dh = "";
			for (YwpzEntity yxq : yxqs) {
				xq = xq + "," + yxq.getXqmc();
			}
			for (YwpzEntity yxm : yxms) {
				xm = xm + "," + yxm.getXmmc();
			}
			for (YwpzEntity ydh : ydhs) {
				dh = dh + "," + ydh.getDhmc();
			}
			for(YwpzEntity y0:y1s){
			y0.setDwmc(y0.getDwmc()+xq+xm+dh);
			}
			if (y1s.size() > 1) {
				String xmbm = "";
				for (YwpzEntity yy : y1s) {
					xmbm = xmbm + yy.getXmbm() + ",";
				}
					y1s.get(0).setXmbm(xmbm);
					baseMapper.insertfzhsmx1dw01(y1s.get(0));
			} else if (y1s.size() == 1) {
					baseMapper.insertfzhsmx1dw01(y1s.get(0));
			}
		}

	}

	// 取消复核
	@Override
	public void updateQXFH(List<DhbmyjEntity> dhyjs) {
		for (DhbmyjEntity d : dhyjs) {
			// 查询该单据的复核状态
			YwpzEntity ywpz = baseMapper.selectfhzt(d.getDjbh());
			if ("0".equals(ywpz.getShzt())) {
				// 则已是未审核
			} else if ("1".equals(ywpz.getShzt())) {
				// 已审核,则取消审核
				baseMapper.updateqxsh(d.getDjbh());
				// 向该开发商sfdw表中记录所缴金额zckje（此金额为未分配金额）
				SfdwEntity sfdwEntity = baseMapper.selectdwxx(ywpz.getDwbm());
				sfdwEntity.setZckje(sfdwEntity.getZckje() - ywpz.getJe());
				baseMapper.updatedwzckje(sfdwEntity);
				// 1.根据该单据编号查询yjmx表
				List<DhbmyjEntity> mxs = baseMapper.selectyjmx(d.getDjbh());
				// 2.根据查询的dhbm查询对应的zhxx，遍历
				for (DhbmyjEntity mx : mxs) {
					ZhxxEntity z = baseMapper.selectzhxx(mx.getDhbm());
					z.setDwze(z.getDwze() - mx.getJe());
					baseMapper.updatezhxx(z);
					// 应该每次取消复核一个单据，也都要检测该单据预交的楼幢应缴金额和已交金额，
					// 如果此时相等则改变楼幢的sfdz为已交清，若应缴金额任然大于已交金额，则sfdz为未交清
					ZhxxEntity z2 = baseMapper.selectzhxx(mx.getDhbm());
					
					Double dwze = z2.getDwze();
				    int res = z2.getYjje().compareTo(dwze);
				    if (res <= 0) {
						baseMapper.updatezhsfdz(z2);// sfdz=1
					} else {
						baseMapper.updatezhsfdz2(z2);// sfdz=0
					}

				}
			}
			//若取消复核，则应当从辅助核算明细表中删除该记录
			List<YwpzEntity> y0=baseMapper.selectfzhsdj(d.getDjbh());
			if(!y0.isEmpty()){
				baseMapper.deletefzhsdj(d.getDjbh());	
			}
		}

	}

	@Override
	public List<DhbmyjEntity> selectCXlz(Map<String, String> map) {
		List<DhbmyjEntity> list = baseMapper.selectyjmx(map.get("djbh"));
		// for (int i = 0; i < list.size(); i++) {
		// // 根据幢号编码查询所属的所有房屋grje
		// double sum = 0.0;
		// try {
		// sum = baseMapper.selectfwbydh(list.get(i).getDhbm());
		// } catch (Exception e) {
		// list.get(i).setGryjje(0.0);
		// }
		// list.get(i).setGryjje(sum);
		// }
		return list;
	}

	public void selectlistglb() {
		// 查询关联表的楼栋编码和预交金额
		List<ZhxxEntity> listglb = baseMapper.selectlistglb();
		// 根据关联表查询栋号表是否存在该栋号
		for (int i = 0; i < listglb.size(); i++) {
			// 查询楼栋表是否存在楼栋编码
			String ldbm = listglb.get(i).getYjdhbm();
			ZhxxEntity ldpd = baseMapper.selectldpd(ldbm);
			if (isObjectNotEmpty(ldpd) == false) {
				System.out.println("==========" + ldbm + "为空");
			} else {
				System.out.println("==========" + ldbm + "插入");
				baseMapper.updateld(listglb.get(i));
			}
		}
	}

	public void selectzhxxsfjq() {// 应缴金额：如果算的结果有一位小数则加0保留两位小数，若有两位小数则最后位四舍五入后加0保留两位小数。
		// 查询zhxx表所有楼幢
		List<ZhxxEntity> list = baseMapper.selectzh();
		// 循环判断每一个楼幢的应缴金额是否相等。
		for (ZhxxEntity z : list) {
			// 按照交款标准算应缴金额
			String jsbz = z.getJsbz();
			if ("0".equals(jsbz)) {// 按面积
				Double yjje = z.getZmj() * z.getJkbz();
				// 取小数点位数
				int a = (yjje + "").length() - (yjje + "").indexOf(".") - 1;
				if (a <= 1) {
					// --
					Double y = z.getDwze();
					int val = yjje.compareTo(y);
					if (val > 0) {
						baseMapper.updatezhsfdz2(z);
					} else if (val < 0) {
						baseMapper.updatezhsfdz(z);
					} else {
						baseMapper.updatezhsfdz(z);
					}
					// --
					// DecimalFormat df = new DecimalFormat("#0.00");
					// String x1=df.format(yjje);
					//
					// String y1=df.format(y).toString();
					// if(x1.equals(y1)){
					// baseMapper.updatezhsfdz(z);
					// System.out.println("==========按面积" + z.getDhbm() +
					// "sfdz=1");
					// }else if(!x1.equals(y1)){
					// baseMapper.updatezhsfdz2(z);
					// System.out.println("==========按面积" + z.getDhbm() +
					// "sfdz=0");
					// }
				} else if (a > 1) {
					// 小数点第二位四舍五入保留两位小数
					Double x = (double) Math.round(yjje * 10) / 10;
					// DecimalFormat df = new DecimalFormat("#0.00");
					// String x1=df.format(x);
					Double y = z.getDwze();
					int val = yjje.compareTo(y);
					if (val > 0) {
						baseMapper.updatezhsfdz2(z);
					} else if (val < 0) {
						baseMapper.updatezhsfdz(z);
					} else {
						baseMapper.updatezhsfdz(z);
					}
					// String y1=df.format(y).toString();
					// if(x1.equals(y1)){
					// baseMapper.updatezhsfdz(z);
					// System.out.println("==========按面积" + z.getDhbm() +
					// "sfdz=1");
					// }else if(!x1.equals(y1)){
					// baseMapper.updatezhsfdz2(z);
					// System.out.println("==========按面积" + z.getDhbm() +
					// "sfdz=0");
					// }

				}
			} else if ("1".equals(jsbz)) {
				Double yjje = z.getZje() * z.getJkbz();
				// 取小数点位数
				int a = (yjje + "").length() - (yjje + "").indexOf(".") - 1;
				if (a <= 1) {
					// DecimalFormat df = new DecimalFormat("#0.00");
					// String x1=df.format(yjje);
					Double y = z.getDwze();
					int val = yjje.compareTo(y);
					if (val > 0) {
						baseMapper.updatezhsfdz2(z);
					} else if (val < 0) {
						baseMapper.updatezhsfdz(z);
					} else {
						baseMapper.updatezhsfdz(z);
					}
					// String y1=df.format(y).toString();
					// if(x1.equals(y1)){
					// baseMapper.updatezhsfdz(z);
					// System.out.println("==========按金额" + z.getDhbm() +
					// "sfdz=1");
					// }else if(!x1.equals(y1)){
					// baseMapper.updatezhsfdz2(z);
					// System.out.println("==========按金额" + z.getDhbm() +
					// "sfdz=0");
					// }
				} else if (a > 1) {
					// 小数点第二位四舍五入保留两位小数
					Double x = (double) Math.round(yjje * 10) / 10;
					// DecimalFormat df = new DecimalFormat("#0.00");
					// String x1=df.format(x);
					Double y = z.getDwze();
					int val = yjje.compareTo(y);
					if (val > 0) {
						baseMapper.updatezhsfdz2(z);
					} else if (val < 0) {
						baseMapper.updatezhsfdz(z);
					} else {
						baseMapper.updatezhsfdz(z);
					}
					// String y1=df.format(y).toString();
					// if(x1.equals(y1)){
					// baseMapper.updatezhsfdz(z);
					// System.out.println("==========按金额" + z.getDhbm() +
					// "sfdz=1");
					// }else if(!x1.equals(y1)){
					// baseMapper.updatezhsfdz2(z);
					// System.out.println("==========按金额" + z.getDhbm() +
					// "sfdz=0");
					// }

				}
			}
		}
	}

	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	public void fwsfyj() {// 脚本方法
		// 原始数据房屋预交的判断就是ywpzmx表中03的单据的fw都是已经预交
		// 过或则预交已审核过的房屋，所有通过脚本将这些房屋的状态fwxx中sfyj字段改为1
		List<FwxxEntity> fwxxEntities = baseMapper.selectyjfwxx();
		for (FwxxEntity f : fwxxEntities) {
			FwxxEntity f1 = baseMapper.selectfw(f.getFwbm());
			if (isObjectNotEmpty(f1) == false) {

			} else {
				baseMapper.updatefwsfyj(f1.getFwbm());
			}
		}
	}

	public void sqrq() {// 脚本方法sqrq或者shrq
		// 查询sqwxzq表中老系统日期格式并转换成新系统日期格式
		List<SqwxzqEntity> list = baseMapper.selectsqrq();
		for (SqwxzqEntity s : list) {
			baseMapper.updatesqrq(s);
		}
	}

	@Override
	public void kfskm() {
		// 查询老数据的所有项目
		List<XmEntity> listxm = baseMapper.selectxm();
		// 找到每一个项目对应的小区，并找到小区对应的科目，刷到对应的项目的kfskm字段上
		for (XmEntity x : listxm) {
			HKmEntity k = baseMapper.selectkmbyxq(x.getXqbm());
			if (isObjectNotEmpty(k) == false) {

			} else {
				x.setKfskm(k.getKm() + "001");
				baseMapper.updatexmkfskm(x);
			}

		}
	}

	@Override
	public void spje() {
		// 查所有的sqje
		List<SqwxzqEntity> list = baseMapper.selectsqje();
		// 将sqje刷到已审核的维修单的spje字段上
		for (SqwxzqEntity s : list) {
			baseMapper.updatespje(s);
		}
	}

	@Override
	public void ywpzdjrq() {
		// 查询老系统ywpz表中djrq去掉00：00：00
		List<YwpzEntity> list = baseMapper.selectywpzdjrq();
		for (YwpzEntity y : list) {
			baseMapper.updateywpzdjrq(y);
		}

	}

	@Override
	public void selectzhxxsfjq2() {
		// Double dwze=57395.0;
		// Double yjje=57395.2;
		// Double x = (double) Math.round(yjje);
		// int res = x.compareTo(dwze);
		// if(res<=0){
		// System.out.println("已");
		// }else{
		// System.out.println("未");
		// }
		// }
		// 查询zhxx表所有楼幢
		List<ZhxxEntity> list = baseMapper.selectzh();
		// 循环判断每一个楼幢的应缴金额是否相等。
		for (ZhxxEntity z : list) {
			// 按照交款标准算应缴金额
			String jsbz = z.getJsbz();
			Double dwze = z.getDwze();// 已交金额
			if ("0".equals(jsbz)) {// 按面积
				Double yjje = z.getZmj() * z.getJkbz();
				Double x = (double) Math.round(yjje);
				int res = x.compareTo(dwze);
				if (res <= 0) {
					baseMapper.updatezhsfdz(z);// sfdz=1
				} else {
					baseMapper.updatezhsfdz2(z);// sfdz=0
				}
			} else if ("1".equals(jsbz)) {
				Double yjje = z.getZje() * z.getJkbz();
				Double x = (double) Math.round(yjje);
				int res = x.compareTo(dwze);
				if (res <= 0) {
					baseMapper.updatezhsfdz(z);// sfdz=1
				} else {
					baseMapper.updatezhsfdz2(z);// sfdz=0
				}
			}
		}
	}
	
	public List<String> findDates(java.util.Date dBegin, java.util.Date dEnd) {
		List<String> lDate = new ArrayList<String>();
		SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM");
		lDate.add(sd.format(dBegin));
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(dBegin);
		Calendar calEnd = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calEnd.setTime(dEnd);
		// 测试此日期是否在指定日期之后
		while (dEnd.after(calBegin.getTime())) {
			// 根据日历的规则，为给定的日历字段添加或减去指定的时间量
			calBegin.add(Calendar.MONTH, 1);
			lDate.add(sd.format(calBegin.getTime()));
		}
		return lDate;
	}

}