package io.renren.modules.app.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.ZhxxDao;
import io.renren.modules.app.entity.WtTyEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.ZhxxService;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("zhxxService")
public class ZhxxServiceImpl extends ServiceImpl<ZhxxDao, ZhxxEntity> implements ZhxxService {

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param zhxxEntity
	 * @return
	 */
	@Override
	public PageInfo<ZhxxEntity> queryByPage(Integer pageNum, Integer pageSize, ZhxxEntity zhxxEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<ZhxxEntity> zhxxEntitys = baseMapper.queryByPage(zhxxEntity);
		PageInfo<ZhxxEntity> pageInfo = new PageInfo<ZhxxEntity>(zhxxEntitys);
		return pageInfo;
	}

	@Override
	public String querydhbm() {
		return baseMapper.querydhbm();
	}

	/**
	 * 单个或批量删除
	 * 
	 * @param ids
	 */
	@Override
	public void deleteBatch(String[] ids) {
		this.deleteBatchIds(Arrays.asList(ids));
	}

	// 下拉类型
	@Override
	public List<WtTyEntity> selectXllx(Map map) {
		List<WtTyEntity> list = new ArrayList<WtTyEntity>();
		if ("gwh".equals(map.get("xllx"))) {
			// 管委会
			list = baseMapper.gwh();
		} else if ("wygs".equals(map.get("xllx"))) {
			// 物业公司
			list = baseMapper.wygs();
		} else if ("fwjg".equals(map.get("xllx"))) {
			// 房屋结构
			list = baseMapper.fwjg();
		} else if ("fwlx".equals(map.get("xllx"))) {
			// 房屋类型
			list = baseMapper.fwlx();
		} else if ("dwjcl".equals(map.get("xllx"))) {
			// 单位缴存率
			list = baseMapper.dwjcl(map);
		} else if ("kfdw".equals(map.get("xllx"))) {
			// 开发单位
			list = baseMapper.kfdw(map);
		} else if ("yzhskm".equals(map.get("xllx"))) {
			// 业主核算科目
			List<WtTyEntity> listtwo = baseMapper.yzhskm();
			String a = null;
			String b = null;
			for (int i = 0; i < listtwo.size(); i++) {
				if (listtwo.get(i).getKm().length() == 3) {
					a = listtwo.get(i).getKmmc();
				} else if (listtwo.get(i).getKm().length() == 6) {
					b = listtwo.get(i).getKmmc();
				} else if (listtwo.get(i).getKm().length() == 9 && "业主".equals(listtwo.get(i).getKmmc())) {
					WtTyEntity pd = new WtTyEntity();
					String c = a + "-" + b + "-" + listtwo.get(i).getKmmc();
					pd.setKm(listtwo.get(i).getKm());
					pd.setKmmc(c);
					list.add(pd);
				}
			}
		}
		return list;
	}

	public static void main(String[] args) {
		Map map = new HashMap();
		map.put("xllx", "yzhskm");
		String param = JSON.toJSONString(map);
		System.out.println(param);
	}

	@Override
	public WtTyEntity selectkm(ZhxxEntity zhxxEntity) {
		WtTyEntity wtTyEntity=baseMapper.selectkm(zhxxEntity.getXmmc());
		wtTyEntity.setKm(wtTyEntity.getKm()+"002");
		wtTyEntity.setKmmc("维修资金科目-"+wtTyEntity.getKmmc()+"-业主");
		return wtTyEntity;
	}

	@Override
	public List<ZhxxEntity> selectzhxx(String id) {
		
		return baseMapper.selectzhxx(id);
	}

	@Override
	public List<ZhxxEntity> selectDhbmList(String xmbm, List<String> dhmcList) {
		return baseMapper.selectDhbmList(xmbm,dhmcList);
	}

	@Override
	public void updatezhxxyjje(ZhxxEntity zhxxEntity) {
		
		baseMapper.updatezhxxyjje(zhxxEntity);
	}

}