package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProRecord;
import com.ruoyi.project.cmplant.service.IProRecordService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-生产记录Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/record")
public class ProRecordController extends BaseController
{
    @Autowired
    private IProRecordService proRecordService;

    /**
     * 查询生产管理-生产记录列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:record:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProRecord proRecord)
    {
        startPage();
        List<ProRecord> list = proRecordService.selectProRecordList(proRecord);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-生产记录列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:record:export')")
    @Log(title = "生产管理-生产记录", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProRecord proRecord)
    {
        List<ProRecord> list = proRecordService.selectProRecordList(proRecord);
        ExcelUtil<ProRecord> util = new ExcelUtil<ProRecord>(ProRecord.class);
        return util.exportExcel(list, "record");
    }

    /**
     * 获取生产管理-生产记录详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:record:query')")
    @GetMapping(value = "/{recordId}")
    public AjaxResult getInfo(@PathVariable("recordId") Long recordId)
    {
        return AjaxResult.success(proRecordService.selectProRecordById(recordId));
    }

    /**
     * 新增生产管理-生产记录
     */
    @PreAuthorize("@ss.hasPermi('cmplant:record:add')")
    @Log(title = "生产管理-生产记录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProRecord proRecord)
    {
        return toAjax(proRecordService.insertProRecord(proRecord));
    }

    /**
     * 修改生产管理-生产记录
     */
    @PreAuthorize("@ss.hasPermi('cmplant:record:edit')")
    @Log(title = "生产管理-生产记录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProRecord proRecord)
    {
        return toAjax(proRecordService.updateProRecord(proRecord));
    }

    /**
     * 删除生产管理-生产记录
     */
    @PreAuthorize("@ss.hasPermi('cmplant:record:remove')")
    @Log(title = "生产管理-生产记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{recordIds}")
    public AjaxResult remove(@PathVariable Long[] recordIds)
    {
        return toAjax(proRecordService.deleteProRecordByIds(recordIds));
    }
}
