package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProductionSyjl;
import com.ruoyi.project.cmplant.service.IProductionSyjlService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 试验管理-试验记录Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/syjl")
public class ProductionSyjlController extends BaseController {
	@Autowired
	private IProductionSyjlService productionSyjlService;

	/**
	 * 查询试验管理-试验记录列表
	 */
	@PreAuthorize("@ss.hasPermi('cmplant:syjl:list')")
	@GetMapping("/list")
	public TableDataInfo list(ProductionSyjl productionSyjl) {
		startPage();
		List<ProductionSyjl> list = productionSyjlService.selectProductionSyjlList(productionSyjl);
		return getDataTable(list);
	}

	/**
	 * 导出试验管理-试验记录列表
	 */
	@PreAuthorize("@ss.hasPermi('cmplant:syjl:export')")
	@Log(title = "试验管理-试验记录", businessType = BusinessType.EXPORT)
	@GetMapping("/export")
	public AjaxResult export(ProductionSyjl productionSyjl) {
		List<ProductionSyjl> list = productionSyjlService.selectProductionSyjlList(productionSyjl);
		ExcelUtil<ProductionSyjl> util = new ExcelUtil<ProductionSyjl>(ProductionSyjl.class);
		return util.exportExcel(list, "syjl");
	}

	/**
	 * 获取试验管理-试验记录详细信息
	 */
	@PreAuthorize("@ss.hasPermi('cmplant:syjl:query')")
	@GetMapping(value = "/{syjlId}")
	public AjaxResult getInfo(@PathVariable("syjlId") Long syjlId) {
		return AjaxResult.success(productionSyjlService.selectProductionSyjlById(syjlId));
	}

	/**
	 * 新增试验管理-试验记录
	 */
	@PreAuthorize("@ss.hasPermi('cmplant:syjl:add')")
	@Log(title = "试验管理-试验记录", businessType = BusinessType.INSERT)
	@PostMapping
	public AjaxResult add(@RequestBody ProductionSyjl productionSyjl) {
		return toAjax(productionSyjlService.insertProductionSyjl(productionSyjl));
	}

	/**
	 * 修改试验管理-试验记录
	 */
	@PreAuthorize("@ss.hasPermi('cmplant:syjl:edit')")
	@Log(title = "试验管理-试验记录", businessType = BusinessType.UPDATE)
	@PutMapping
	public AjaxResult edit(@RequestBody ProductionSyjl productionSyjl) {
		return toAjax(productionSyjlService.updateProductionSyjl(productionSyjl));
	}

	/**
	 * 删除试验管理-试验记录
	 */
	@PreAuthorize("@ss.hasPermi('cmplant:syjl:remove')")
	@Log(title = "试验管理-试验记录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{syjlIds}")
	public AjaxResult remove(@PathVariable Long[] syjlIds) {
		return toAjax(productionSyjlService.deleteProductionSyjlByIds(syjlIds));
	}
}
