package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.TransportYsjl;
import com.ruoyi.project.cmplant.service.ITransportYsjlService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 运输管理-运输监测Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/ysjl")
public class TransportYsjlController extends BaseController
{
    @Autowired
    private ITransportYsjlService transportYsjlService;

    /**
     * 查询运输管理-运输监测列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjl:list')")
    @GetMapping("/list")
    public TableDataInfo list(TransportYsjl transportYsjl)
    {
        startPage();
        List<TransportYsjl> list = transportYsjlService.selectTransportYsjlList(transportYsjl);
        return getDataTable(list);
    }

    /**
     * 导出运输管理-运输监测列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjl:export')")
    @Log(title = "运输管理-运输监测", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TransportYsjl transportYsjl)
    {
        List<TransportYsjl> list = transportYsjlService.selectTransportYsjlList(transportYsjl);
        ExcelUtil<TransportYsjl> util = new ExcelUtil<TransportYsjl>(TransportYsjl.class);
        return util.exportExcel(list, "ysjl");
    }

    /**
     * 获取运输管理-运输监测详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjl:query')")
    @GetMapping(value = "/{ysjcId}")
    public AjaxResult getInfo(@PathVariable("ysjcId") Long ysjcId)
    {
        return AjaxResult.success(transportYsjlService.selectTransportYsjlById(ysjcId));
    }

    /**
     * 新增运输管理-运输监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjl:add')")
    @Log(title = "运输管理-运输监测", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TransportYsjl transportYsjl)
    {
        return toAjax(transportYsjlService.insertTransportYsjl(transportYsjl));
    }

    /**
     * 修改运输管理-运输监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjl:edit')")
    @Log(title = "运输管理-运输监测", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TransportYsjl transportYsjl)
    {
        return toAjax(transportYsjlService.updateTransportYsjl(transportYsjl));
    }

    /**
     * 删除运输管理-运输监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:ysjl:remove')")
    @Log(title = "运输管理-运输监测", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ysjcIds}")
    public AjaxResult remove(@PathVariable Long[] ysjcIds)
    {
        return toAjax(transportYsjlService.deleteTransportYsjlByIds(ysjcIds));
    }
}
