package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 生产管理-数据监测对象 pro_datmon
 * 
 * @author lihang
 * @date 2020-08-28
 */
public class ProDatmon extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 数据监测主键ID */
    private Long damonId;

    /** 企业信息主键ID */
    @Excel(name = "企业信息主键ID")
    private Long todoId;

    /** 生产任务单号 */
    @Excel(name = "生产任务单号")
    private String todoNumbers;

    /** 搅拌站主键ID */
    @Excel(name = "搅拌站主键ID")
    private Long miplantId;

    /** 计划生产数量 */
    @Excel(name = "计划生产数量")
    private Integer damonPlanpronums;

    /** 实际生产数量 */
    @Excel(name = "实际生产数量")
    private Integer damonPranpronums;

    /** 计划开盘时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "计划开盘时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date damonPlanopentime;

    /** 实际开盘时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "实际开盘时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date damonPranopentime;

    /** 计划结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "计划结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date damonPlanfinishtime;

    /** 实际结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "实际结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date damonPranfinishtime;

    /** 配合比执行状况 */
    @Excel(name = "配合比执行状况")
    private String damonMixstatus;

    /** 计量差 */
    @Excel(name = "计量差")
    private String damonPoor;

    /** 状态 0删除 1保存 2上报 */
    @Excel(name = "状态 0删除 1保存 2上报")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    /** 搅拌站名称 */
    @Excel(name = "搅拌站名称")
    private String miplantName;
    
    
    public String getEninfoName() {
		return eninfoName;
	}

	public void setEninfoName(String eninfoName) {
		this.eninfoName = eninfoName;
	}

	public String getXzqhmc() {
		return xzqhmc;
	}

	public void setXzqhmc(String xzqhmc) {
		this.xzqhmc = xzqhmc;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}

	public String getMiplantName() {
		return miplantName;
	}

	public void setMiplantName(String miplantName) {
		this.miplantName = miplantName;
	}

	public void setDamonId(Long damonId) 
    {
        this.damonId = damonId;
    }

    public Long getDamonId() 
    {
        return damonId;
    }
    public void setTodoId(Long todoId) 
    {
        this.todoId = todoId;
    }

    public Long getTodoId() 
    {
        return todoId;
    }
    public void setTodoNumbers(String todoNumbers) 
    {
        this.todoNumbers = todoNumbers;
    }

    public String getTodoNumbers() 
    {
        return todoNumbers;
    }
    public void setMiplantId(Long miplantId) 
    {
        this.miplantId = miplantId;
    }

    public Long getMiplantId() 
    {
        return miplantId;
    }
    public void setDamonPlanpronums(Integer damonPlanpronums) 
    {
        this.damonPlanpronums = damonPlanpronums;
    }

    public Integer getDamonPlanpronums() 
    {
        return damonPlanpronums;
    }
    public void setDamonPranpronums(Integer damonPranpronums) 
    {
        this.damonPranpronums = damonPranpronums;
    }

    public Integer getDamonPranpronums() 
    {
        return damonPranpronums;
    }
    public void setDamonPlanopentime(Date damonPlanopentime) 
    {
        this.damonPlanopentime = damonPlanopentime;
    }

    public Date getDamonPlanopentime() 
    {
        return damonPlanopentime;
    }
    public void setDamonPranopentime(Date damonPranopentime) 
    {
        this.damonPranopentime = damonPranopentime;
    }

    public Date getDamonPranopentime() 
    {
        return damonPranopentime;
    }
    public void setDamonPlanfinishtime(Date damonPlanfinishtime) 
    {
        this.damonPlanfinishtime = damonPlanfinishtime;
    }

    public Date getDamonPlanfinishtime() 
    {
        return damonPlanfinishtime;
    }
    public void setDamonPranfinishtime(Date damonPranfinishtime) 
    {
        this.damonPranfinishtime = damonPranfinishtime;
    }

    public Date getDamonPranfinishtime() 
    {
        return damonPranfinishtime;
    }
    public void setDamonMixstatus(String damonMixstatus) 
    {
        this.damonMixstatus = damonMixstatus;
    }

    public String getDamonMixstatus() 
    {
        return damonMixstatus;
    }
    public void setDamonPoor(String damonPoor) 
    {
        this.damonPoor = damonPoor;
    }

    public String getDamonPoor() 
    {
        return damonPoor;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("damonId", getDamonId())
            .append("todoId", getTodoId())
            .append("todoNumbers", getTodoNumbers())
            .append("miplantId", getMiplantId())
            .append("damonPlanpronums", getDamonPlanpronums())
            .append("damonPranpronums", getDamonPranpronums())
            .append("damonPlanopentime", getDamonPlanopentime())
            .append("damonPranopentime", getDamonPranopentime())
            .append("damonPlanfinishtime", getDamonPlanfinishtime())
            .append("damonPranfinishtime", getDamonPranfinishtime())
            .append("damonMixstatus", getDamonMixstatus())
            .append("damonPoor", getDamonPoor())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
