package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.BainfoEncert;

/**
 * 基础信息-企业资质Mapper接口
 * 
 * @author lihang
 * @date 2020-08-26
 */
public interface BainfoEncertMapper 
{
    /**
     * 查询基础信息-企业资质
     * 
     * @param encertId 基础信息-企业资质ID
     * @return 基础信息-企业资质
     */
    public BainfoEncert selectBainfoEncertById(Long encertId);

    /**
     * 查询基础信息-企业资质列表
     * 
     * @param bainfoEncert 基础信息-企业资质
     * @return 基础信息-企业资质集合
     */
    public List<BainfoEncert> selectBainfoEncertList(BainfoEncert bainfoEncert);

    /**
     * 新增基础信息-企业资质
     * 
     * @param bainfoEncert 基础信息-企业资质
     * @return 结果
     */
    public int insertBainfoEncert(BainfoEncert bainfoEncert);

    /**
     * 修改基础信息-企业资质
     * 
     * @param bainfoEncert 基础信息-企业资质
     * @return 结果
     */
    public int updateBainfoEncert(BainfoEncert bainfoEncert);

    /**
     * 删除基础信息-企业资质
     * 
     * @param encertId 基础信息-企业资质ID
     * @return 结果
     */
    public int deleteBainfoEncertById(Long encertId);

    /**
     * 批量删除基础信息-企业资质
     * 
     * @param encertIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteBainfoEncertByIds(Long[] encertIds);
}
