package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProductionSyjl;

/**
 * 试验管理-试验记录Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface ProductionSyjlMapper 
{
    /**
     * 查询试验管理-试验记录
     * 
     * @param syjlId 试验管理-试验记录ID
     * @return 试验管理-试验记录
     */
    public ProductionSyjl selectProductionSyjlById(Long syjlId);

    /**
     * 查询试验管理-试验记录列表
     * 
     * @param productionSyjl 试验管理-试验记录
     * @return 试验管理-试验记录集合
     */
    public List<ProductionSyjl> selectProductionSyjlList(ProductionSyjl productionSyjl);

    /**
     * 新增试验管理-试验记录
     * 
     * @param productionSyjl 试验管理-试验记录
     * @return 结果
     */
    public int insertProductionSyjl(ProductionSyjl productionSyjl);

    /**
     * 修改试验管理-试验记录
     * 
     * @param productionSyjl 试验管理-试验记录
     * @return 结果
     */
    public int updateProductionSyjl(ProductionSyjl productionSyjl);

    /**
     * 删除试验管理-试验记录
     * 
     * @param syjlId 试验管理-试验记录ID
     * @return 结果
     */
    public int deleteProductionSyjlById(Long syjlId);

    /**
     * 批量删除试验管理-试验记录
     * 
     * @param syjlIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteProductionSyjlByIds(Long[] syjlIds);
}
