package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProStatis;

/**
 * 生产管理-生产统计Service接口
 * 
 * @author lihang
 * @date 2020-08-28
 */
public interface IProStatisService 
{
    /**
     * 查询生产管理-生产统计
     * 
     * @param statisId 生产管理-生产统计ID
     * @return 生产管理-生产统计
     */
    public ProStatis selectProStatisById(Long statisId);

    /**
     * 查询生产管理-生产统计列表
     * 
     * @param proStatis 生产管理-生产统计
     * @return 生产管理-生产统计集合
     */
    public List<ProStatis> selectProStatisList(ProStatis proStatis);

    /**
     * 新增生产管理-生产统计
     * 
     * @param proStatis 生产管理-生产统计
     * @return 结果
     */
    public int insertProStatis(ProStatis proStatis);

    /**
     * 修改生产管理-生产统计
     * 
     * @param proStatis 生产管理-生产统计
     * @return 结果
     */
    public int updateProStatis(ProStatis proStatis);

    /**
     * 批量删除生产管理-生产统计
     * 
     * @param statisIds 需要删除的生产管理-生产统计ID
     * @return 结果
     */
    public int deleteProStatisByIds(Long[] statisIds);

    /**
     * 删除生产管理-生产统计信息
     * 
     * @param statisId 生产管理-生产统计ID
     * @return 结果
     */
    public int deleteProStatisById(Long statisId);
}
