package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.TransportYsjl;

/**
 * 运输管理-运输监测Service接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface ITransportYsjlService 
{
    /**
     * 查询运输管理-运输监测
     * 
     * @param ysjcId 运输管理-运输监测ID
     * @return 运输管理-运输监测
     */
    public TransportYsjl selectTransportYsjlById(Long ysjcId);

    /**
     * 查询运输管理-运输监测列表
     * 
     * @param transportYsjl 运输管理-运输监测
     * @return 运输管理-运输监测集合
     */
    public List<TransportYsjl> selectTransportYsjlList(TransportYsjl transportYsjl);

    /**
     * 新增运输管理-运输监测
     * 
     * @param transportYsjl 运输管理-运输监测
     * @return 结果
     */
    public int insertTransportYsjl(TransportYsjl transportYsjl);

    /**
     * 修改运输管理-运输监测
     * 
     * @param transportYsjl 运输管理-运输监测
     * @return 结果
     */
    public int updateTransportYsjl(TransportYsjl transportYsjl);

    /**
     * 批量删除运输管理-运输监测
     * 
     * @param ysjcIds 需要删除的运输管理-运输监测ID
     * @return 结果
     */
    public int deleteTransportYsjlByIds(Long[] ysjcIds);

    /**
     * 删除运输管理-运输监测信息
     * 
     * @param ysjcId 运输管理-运输监测ID
     * @return 结果
     */
    public int deleteTransportYsjlById(Long ysjcId);
}
