package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProPurPdetMapper;
import com.ruoyi.project.cmplant.domain.ProPurPdet;
import com.ruoyi.project.cmplant.service.IProPurPdetService;

/**
 * 生产管理-采购订单-采购明细Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProPurPdetServiceImpl implements IProPurPdetService 
{
    @Autowired
    private ProPurPdetMapper proPurPdetMapper;

    /**
     * 查询生产管理-采购订单-采购明细
     * 
     * @param pdetId 生产管理-采购订单-采购明细ID
     * @return 生产管理-采购订单-采购明细
     */
    @Override
    public ProPurPdet selectProPurPdetById(Long pdetId)
    {
        return proPurPdetMapper.selectProPurPdetById(pdetId);
    }

    /**
     * 查询生产管理-采购订单-采购明细列表
     * 
     * @param proPurPdet 生产管理-采购订单-采购明细
     * @return 生产管理-采购订单-采购明细
     */
    @Override
    public List<ProPurPdet> selectProPurPdetList(ProPurPdet proPurPdet)
    {
        return proPurPdetMapper.selectProPurPdetList(proPurPdet);
    }

    /**
     * 新增生产管理-采购订单-采购明细
     * 
     * @param proPurPdet 生产管理-采购订单-采购明细
     * @return 结果
     */
    @Override
    public int insertProPurPdet(ProPurPdet proPurPdet)
    {
        proPurPdet.setCreateTime(DateUtils.getNowDate());
        return proPurPdetMapper.insertProPurPdet(proPurPdet);
    }

    /**
     * 修改生产管理-采购订单-采购明细
     * 
     * @param proPurPdet 生产管理-采购订单-采购明细
     * @return 结果
     */
    @Override
    public int updateProPurPdet(ProPurPdet proPurPdet)
    {
        proPurPdet.setUpdateTime(DateUtils.getNowDate());
        return proPurPdetMapper.updateProPurPdet(proPurPdet);
    }

    /**
     * 批量删除生产管理-采购订单-采购明细
     * 
     * @param pdetIds 需要删除的生产管理-采购订单-采购明细ID
     * @return 结果
     */
    @Override
    public int deleteProPurPdetByIds(Long[] pdetIds)
    {
        return proPurPdetMapper.deleteProPurPdetByIds(pdetIds);
    }

    /**
     * 删除生产管理-采购订单-采购明细信息
     * 
     * @param pdetId 生产管理-采购订单-采购明细ID
     * @return 结果
     */
    @Override
    public int deleteProPurPdetById(Long pdetId)
    {
        return proPurPdetMapper.deleteProPurPdetById(pdetId);
    }
}
