package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProRecordRawdetMapper;
import com.ruoyi.project.cmplant.domain.ProRecordRawdet;
import com.ruoyi.project.cmplant.service.IProRecordRawdetService;

/**
 * 生产管理-生产记录-原材料清单Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProRecordRawdetServiceImpl implements IProRecordRawdetService 
{
    @Autowired
    private ProRecordRawdetMapper proRecordRawdetMapper;

    /**
     * 查询生产管理-生产记录-原材料清单
     * 
     * @param rawdetId 生产管理-生产记录-原材料清单ID
     * @return 生产管理-生产记录-原材料清单
     */
    @Override
    public ProRecordRawdet selectProRecordRawdetById(Long rawdetId)
    {
        return proRecordRawdetMapper.selectProRecordRawdetById(rawdetId);
    }

    /**
     * 查询生产管理-生产记录-原材料清单列表
     * 
     * @param proRecordRawdet 生产管理-生产记录-原材料清单
     * @return 生产管理-生产记录-原材料清单
     */
    @Override
    public List<ProRecordRawdet> selectProRecordRawdetList(ProRecordRawdet proRecordRawdet)
    {
        return proRecordRawdetMapper.selectProRecordRawdetList(proRecordRawdet);
    }

    /**
     * 新增生产管理-生产记录-原材料清单
     * 
     * @param proRecordRawdet 生产管理-生产记录-原材料清单
     * @return 结果
     */
    @Override
    public int insertProRecordRawdet(ProRecordRawdet proRecordRawdet)
    {
        proRecordRawdet.setCreateTime(DateUtils.getNowDate());
        return proRecordRawdetMapper.insertProRecordRawdet(proRecordRawdet);
    }

    /**
     * 修改生产管理-生产记录-原材料清单
     * 
     * @param proRecordRawdet 生产管理-生产记录-原材料清单
     * @return 结果
     */
    @Override
    public int updateProRecordRawdet(ProRecordRawdet proRecordRawdet)
    {
        proRecordRawdet.setUpdateTime(DateUtils.getNowDate());
        return proRecordRawdetMapper.updateProRecordRawdet(proRecordRawdet);
    }

    /**
     * 批量删除生产管理-生产记录-原材料清单
     * 
     * @param rawdetIds 需要删除的生产管理-生产记录-原材料清单ID
     * @return 结果
     */
    @Override
    public int deleteProRecordRawdetByIds(Long[] rawdetIds)
    {
        return proRecordRawdetMapper.deleteProRecordRawdetByIds(rawdetIds);
    }

    /**
     * 删除生产管理-生产记录-原材料清单信息
     * 
     * @param rawdetId 生产管理-生产记录-原材料清单ID
     * @return 结果
     */
    @Override
    public int deleteProRecordRawdetById(Long rawdetId)
    {
        return proRecordRawdetMapper.deleteProRecordRawdetById(rawdetId);
    }
}
