package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProductionPhbglMapper;
import com.ruoyi.project.cmplant.domain.ProductionPhbgl;
import com.ruoyi.project.cmplant.service.IProductionPhbglService;

/**
 * 试验管理-配合比管理Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProductionPhbglServiceImpl implements IProductionPhbglService 
{
    @Autowired
    private ProductionPhbglMapper productionPhbglMapper;

    /**
     * 查询试验管理-配合比管理
     * 
     * @param phbglId 试验管理-配合比管理ID
     * @return 试验管理-配合比管理
     */
    @Override
    public ProductionPhbgl selectProductionPhbglById(Long phbglId)
    {
        return productionPhbglMapper.selectProductionPhbglById(phbglId);
    }

    /**
     * 查询试验管理-配合比管理列表
     * 
     * @param productionPhbgl 试验管理-配合比管理
     * @return 试验管理-配合比管理
     */
    @Override
    public List<ProductionPhbgl> selectProductionPhbglList(ProductionPhbgl productionPhbgl)
    {
        return productionPhbglMapper.selectProductionPhbglList(productionPhbgl);
    }

    /**
     * 新增试验管理-配合比管理
     * 
     * @param productionPhbgl 试验管理-配合比管理
     * @return 结果
     */
    @Override
    public int insertProductionPhbgl(ProductionPhbgl productionPhbgl)
    {
        productionPhbgl.setCreateTime(DateUtils.getNowDate());
        return productionPhbglMapper.insertProductionPhbgl(productionPhbgl);
    }

    /**
     * 修改试验管理-配合比管理
     * 
     * @param productionPhbgl 试验管理-配合比管理
     * @return 结果
     */
    @Override
    public int updateProductionPhbgl(ProductionPhbgl productionPhbgl)
    {
        productionPhbgl.setUpdateTime(DateUtils.getNowDate());
        return productionPhbglMapper.updateProductionPhbgl(productionPhbgl);
    }

    /**
     * 批量删除试验管理-配合比管理
     * 
     * @param phbglIds 需要删除的试验管理-配合比管理ID
     * @return 结果
     */
    @Override
    public int deleteProductionPhbglByIds(Long[] phbglIds)
    {
        return productionPhbglMapper.deleteProductionPhbglByIds(phbglIds);
    }

    /**
     * 删除试验管理-配合比管理信息
     * 
     * @param phbglId 试验管理-配合比管理ID
     * @return 结果
     */
    @Override
    public int deleteProductionPhbglById(Long phbglId)
    {
        return productionPhbglMapper.deleteProductionPhbglById(phbglId);
    }
}
