package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.BainfoMiplant;
import com.ruoyi.project.cmplant.service.IBainfoMiplantService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 基础信息-搅拌站管理Controller
 * 
 * @author lihang
 * @date 2020-08-26
 */
@RestController
@RequestMapping("/cmplant/miplant")
public class BainfoMiplantController extends BaseController
{
    @Autowired
    private IBainfoMiplantService bainfoMiplantService;

    /**
     * 查询基础信息-搅拌站管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:miplant:list')")
    @GetMapping("/list")
    public TableDataInfo list(BainfoMiplant bainfoMiplant)
    {
        startPage();
        List<BainfoMiplant> list = bainfoMiplantService.selectBainfoMiplantList(bainfoMiplant);
        return getDataTable(list);
    }

    /**
     * 导出基础信息-搅拌站管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:miplant:export')")
    @Log(title = "基础信息-搅拌站管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(BainfoMiplant bainfoMiplant)
    {
        List<BainfoMiplant> list = bainfoMiplantService.selectBainfoMiplantList(bainfoMiplant);
        ExcelUtil<BainfoMiplant> util = new ExcelUtil<BainfoMiplant>(BainfoMiplant.class);
        return util.exportExcel(list, "miplant");
    }

    /**
     * 获取基础信息-搅拌站管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:miplant:query')")
    @GetMapping(value = "/{miplantId}")
    public AjaxResult getInfo(@PathVariable("miplantId") Long miplantId)
    {
        return AjaxResult.success(bainfoMiplantService.selectBainfoMiplantById(miplantId));
    }

    /**
     * 新增基础信息-搅拌站管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:miplant:add')")
    @Log(title = "基础信息-搅拌站管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BainfoMiplant bainfoMiplant)
    {
        return toAjax(bainfoMiplantService.insertBainfoMiplant(bainfoMiplant));
    }

    /**
     * 修改基础信息-搅拌站管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:miplant:edit')")
    @Log(title = "基础信息-搅拌站管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BainfoMiplant bainfoMiplant)
    {
        return toAjax(bainfoMiplantService.updateBainfoMiplant(bainfoMiplant));
    }

    /**
     * 删除基础信息-搅拌站管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:miplant:remove')")
    @Log(title = "基础信息-搅拌站管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{miplantIds}")
    public AjaxResult remove(@PathVariable Long[] miplantIds)
    {
        return toAjax(bainfoMiplantService.deleteBainfoMiplantByIds(miplantIds));
    }
}
