package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProPur;
import com.ruoyi.project.cmplant.service.IProPurService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-采购订单Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/pur")
public class ProPurController extends BaseController
{
    @Autowired
    private IProPurService proPurService;

    /**
     * 查询生产管理-采购订单列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pur:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPur proPur)
    {
        startPage();
        List<ProPur> list = proPurService.selectProPurList(proPur);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-采购订单列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pur:export')")
    @Log(title = "生产管理-采购订单", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProPur proPur)
    {
        List<ProPur> list = proPurService.selectProPurList(proPur);
        ExcelUtil<ProPur> util = new ExcelUtil<ProPur>(ProPur.class);
        return util.exportExcel(list, "pur");
    }

    /**
     * 获取生产管理-采购订单详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pur:query')")
    @GetMapping(value = "/{purId}")
    public AjaxResult getInfo(@PathVariable("purId") Long purId)
    {
        return AjaxResult.success(proPurService.selectProPurById(purId));
    }

    /**
     * 新增生产管理-采购订单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pur:add')")
    @Log(title = "生产管理-采购订单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPur proPur)
    {
        return toAjax(proPurService.insertProPur(proPur));
    }

    /**
     * 修改生产管理-采购订单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pur:edit')")
    @Log(title = "生产管理-采购订单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPur proPur)
    {
        return toAjax(proPurService.updateProPur(proPur));
    }

    /**
     * 删除生产管理-采购订单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:pur:remove')")
    @Log(title = "生产管理-采购订单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{purIds}")
    public AjaxResult remove(@PathVariable Long[] purIds)
    {
        return toAjax(proPurService.deleteProPurByIds(purIds));
    }
}
