package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProTodo;
import com.ruoyi.project.cmplant.service.IProTodoService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-生产任务单Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/todo")
public class ProTodoController extends BaseController
{
    @Autowired
    private IProTodoService proTodoService;

    /**
     * 查询生产管理-生产任务单列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:todo:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProTodo proTodo)
    {
        startPage();
        List<ProTodo> list = proTodoService.selectProTodoList(proTodo);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-生产任务单列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:todo:export')")
    @Log(title = "生产管理-生产任务单", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProTodo proTodo)
    {
        List<ProTodo> list = proTodoService.selectProTodoList(proTodo);
        ExcelUtil<ProTodo> util = new ExcelUtil<ProTodo>(ProTodo.class);
        return util.exportExcel(list, "todo");
    }

    /**
     * 获取生产管理-生产任务单详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:todo:query')")
    @GetMapping(value = "/{todoId}")
    public AjaxResult getInfo(@PathVariable("todoId") Long todoId)
    {
        return AjaxResult.success(proTodoService.selectProTodoById(todoId));
    }

    /**
     * 新增生产管理-生产任务单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:todo:add')")
    @Log(title = "生产管理-生产任务单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProTodo proTodo)
    {
        return toAjax(proTodoService.insertProTodo(proTodo));
    }

    /**
     * 修改生产管理-生产任务单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:todo:edit')")
    @Log(title = "生产管理-生产任务单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProTodo proTodo)
    {
        return toAjax(proTodoService.updateProTodo(proTodo));
    }

    /**
     * 删除生产管理-生产任务单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:todo:remove')")
    @Log(title = "生产管理-生产任务单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{todoIds}")
    public AjaxResult remove(@PathVariable Long[] todoIds)
    {
        return toAjax(proTodoService.deleteProTodoByIds(todoIds));
    }
}
