package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 基础信息-车辆管理对象 bainfo_car
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class BainfoCar extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 车辆主键id */
    private Long carId;

    /** 企业信息主键ID（关联主键） */
    @Excel(name = "企业信息主键ID", readConverterExp = "关=联主键")
    private Long eninfoId;

    /** 车辆名称 */
    @Excel(name = "车辆编号")
    private String carSernum;

    /** 车辆型号 */
    @Excel(name = "车辆型号")
    private String carModel;

    /** 车辆容积 */
    @Excel(name = "车辆容积")
    private Double carVolume;

    /** 采购日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "采购日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date carPurtime;

    /** 生产厂家 */
    @Excel(name = "生产厂家")
    private String carManu;

    /** 行车证 */
    @Excel(name = "行车证")
    private String carVelicen;

    /** 年检时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "年检时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date carAstime;

    /** 车辆状态 0异常 1正常 */
    @Excel(name = "车辆状态 0异常 1正常")
    private Integer carStatus;

    /** 0删除 1保存 */
    @Excel(name = "0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }
    public void setCarId(Long carId) 
    {
        this.carId = carId;
    }

    public Long getCarId() 
    {
        return carId;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setCarSernum(String carSernum) 
    {
        this.carSernum = carSernum;
    }

    public String getCarSernum() 
    {
        return carSernum;
    }
    public void setCarModel(String carModel) 
    {
        this.carModel = carModel;
    }

    public String getCarModel() 
    {
        return carModel;
    }
    public void setCarVolume(Double carVolume) 
    {
        this.carVolume = carVolume;
    }

    public Double getCarVolume() 
    {
        return carVolume;
    }
    public void setCarPurtime(Date carPurtime) 
    {
        this.carPurtime = carPurtime;
    }

    public Date getCarPurtime() 
    {
        return carPurtime;
    }
    public void setCarManu(String carManu) 
    {
        this.carManu = carManu;
    }

    public String getCarManu() 
    {
        return carManu;
    }
    public void setCarVelicen(String carVelicen) 
    {
        this.carVelicen = carVelicen;
    }

    public String getCarVelicen() 
    {
        return carVelicen;
    }
    public void setCarAstime(Date carAstime) 
    {
        this.carAstime = carAstime;
    }

    public Date getCarAstime() 
    {
        return carAstime;
    }
    public void setCarStatus(Integer carStatus) 
    {
        this.carStatus = carStatus;
    }

    public Integer getCarStatus() 
    {
        return carStatus;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("carId", getCarId())
            .append("eninfoId", getEninfoId())
            .append("carSernum", getCarSernum())
            .append("carModel", getCarModel())
            .append("carVolume", getCarVolume())
            .append("carPurtime", getCarPurtime())
            .append("carManu", getCarManu())
            .append("carVelicen", getCarVelicen())
            .append("carAstime", getCarAstime())
            .append("carStatus", getCarStatus())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
