package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 基础信息-人员管理对象 bainfo_staff
 * 
 * @author lihang
 * @date 2020-08-26
 */
public class BainfoStaff extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 人员主键ID */
    private Long staffId;

    /** 企业信息主键ID（关联主键） */
    @Excel(name = "企业信息主键ID", readConverterExp = "关=联主键")
    private Long eninfoId;

    /** 人员名称 */
    @Excel(name = "人员名称")
    private String staffName;

    /** 人员编号 */
    @Excel(name = "人员编号")
    private String staffNumber;

    /** 部门名称 */
    @Excel(name = "部门名称")
    private String staffDepname;

    /** 岗位 */
    @Excel(name = "岗位")
    private String staffPost;

    /** 职能证书 */
    @Excel(name = "职能证书")
    private String staffFuninfo;

    /** 身份证号码 */
    @Excel(name = "身份证号码")
    private String staffIcnum;

    /** 入职时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "入职时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date staffEntrytime;

    /** 联系电话 */
    @Excel(name = "联系电话")
    private String staffPhone;

    /** 劳动合同 */
    @Excel(name = "劳动合同")
    private String staffLaborcon;

    /** 0离职 1在职 */
    @Excel(name = "0离职 1在职")
    private Integer staffStatus;

    /** 0删除 1保存 */
    @Excel(name = "0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }
    public void setStaffId(Long staffId) 
    {
        this.staffId = staffId;
    }

    public Long getStaffId() 
    {
        return staffId;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setStaffName(String staffName) 
    {
        this.staffName = staffName;
    }

    public String getStaffName() 
    {
        return staffName;
    }
    public void setStaffNumber(String staffNumber) 
    {
        this.staffNumber = staffNumber;
    }

    public String getStaffNumber() 
    {
        return staffNumber;
    }
    public void setStaffDepname(String staffDepname) 
    {
        this.staffDepname = staffDepname;
    }

    public String getStaffDepname() 
    {
        return staffDepname;
    }
    public void setStaffPost(String staffPost) 
    {
        this.staffPost = staffPost;
    }

    public String getStaffPost() 
    {
        return staffPost;
    }
    public void setStaffFuninfo(String staffFuninfo) 
    {
        this.staffFuninfo = staffFuninfo;
    }

    public String getStaffFuninfo() 
    {
        return staffFuninfo;
    }
    public void setStaffIcnum(String staffIcnum) 
    {
        this.staffIcnum = staffIcnum;
    }

    public String getStaffIcnum() 
    {
        return staffIcnum;
    }
    public void setStaffEntrytime(Date staffEntrytime) 
    {
        this.staffEntrytime = staffEntrytime;
    }

    public Date getStaffEntrytime() 
    {
        return staffEntrytime;
    }
    public void setStaffPhone(String staffPhone) 
    {
        this.staffPhone = staffPhone;
    }

    public String getStaffPhone() 
    {
        return staffPhone;
    }
    public void setStaffLaborcon(String staffLaborcon) 
    {
        this.staffLaborcon = staffLaborcon;
    }

    public String getStaffLaborcon() 
    {
        return staffLaborcon;
    }
    public void setStaffStatus(Integer staffStatus) 
    {
        this.staffStatus = staffStatus;
    }

    public Integer getStaffStatus() 
    {
        return staffStatus;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("staffId", getStaffId())
            .append("eninfoId", getEninfoId())
            .append("staffName", getStaffName())
            .append("staffNumber", getStaffNumber())
            .append("staffDepname", getStaffDepname())
            .append("staffPost", getStaffPost())
            .append("staffFuninfo", getStaffFuninfo())
            .append("staffIcnum", getStaffIcnum())
            .append("staffEntrytime", getStaffEntrytime())
            .append("staffPhone", getStaffPhone())
            .append("staffLaborcon", getStaffLaborcon())
            .append("staffStatus", getStaffStatus())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
