package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProductionPhbgl;

/**
 * 试验管理-配合比管理Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface ProductionPhbglMapper 
{
    /**
     * 查询试验管理-配合比管理
     * 
     * @param phbglId 试验管理-配合比管理ID
     * @return 试验管理-配合比管理
     */
    public ProductionPhbgl selectProductionPhbglById(Long phbglId);

    /**
     * 查询试验管理-配合比管理列表
     * 
     * @param productionPhbgl 试验管理-配合比管理
     * @return 试验管理-配合比管理集合
     */
    public List<ProductionPhbgl> selectProductionPhbglList(ProductionPhbgl productionPhbgl);

    /**
     * 新增试验管理-配合比管理
     * 
     * @param productionPhbgl 试验管理-配合比管理
     * @return 结果
     */
    public int insertProductionPhbgl(ProductionPhbgl productionPhbgl);

    /**
     * 修改试验管理-配合比管理
     * 
     * @param productionPhbgl 试验管理-配合比管理
     * @return 结果
     */
    public int updateProductionPhbgl(ProductionPhbgl productionPhbgl);

    /**
     * 删除试验管理-配合比管理
     * 
     * @param phbglId 试验管理-配合比管理ID
     * @return 结果
     */
    public int deleteProductionPhbglById(Long phbglId);

    /**
     * 批量删除试验管理-配合比管理
     * 
     * @param phbglIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteProductionPhbglByIds(Long[] phbglIds);
}
