package com.ruoyi.project.cmplant.mapper;

import java.util.List;
import com.ruoyi.project.cmplant.domain.TransportYstj;

/**
 * 运输管理-运输统计Mapper接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface TransportYstjMapper 
{
    /**
     * 查询运输管理-运输统计
     * 
     * @param ystjId 运输管理-运输统计ID
     * @return 运输管理-运输统计
     */
    public TransportYstj selectTransportYstjById(Long ystjId);

    /**
     * 查询运输管理-运输统计列表
     * 
     * @param transportYstj 运输管理-运输统计
     * @return 运输管理-运输统计集合
     */
    public List<TransportYstj> selectTransportYstjList(TransportYstj transportYstj);

    /**
     * 新增运输管理-运输统计
     * 
     * @param transportYstj 运输管理-运输统计
     * @return 结果
     */
    public int insertTransportYstj(TransportYstj transportYstj);

    /**
     * 修改运输管理-运输统计
     * 
     * @param transportYstj 运输管理-运输统计
     * @return 结果
     */
    public int updateTransportYstj(TransportYstj transportYstj);

    /**
     * 删除运输管理-运输统计
     * 
     * @param ystjId 运输管理-运输统计ID
     * @return 结果
     */
    public int deleteTransportYstjById(Long ystjId);

    /**
     * 批量删除运输管理-运输统计
     * 
     * @param ystjIds 需要删除的数据ID
     * @return 结果
     */
    public int deleteTransportYstjByIds(Long[] ystjIds);
}
