package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProRecordRawdet;

/**
 * 生产管理-生产记录-原材料清单Service接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface IProRecordRawdetService 
{
    /**
     * 查询生产管理-生产记录-原材料清单
     * 
     * @param rawdetId 生产管理-生产记录-原材料清单ID
     * @return 生产管理-生产记录-原材料清单
     */
    public ProRecordRawdet selectProRecordRawdetById(Long rawdetId);

    /**
     * 查询生产管理-生产记录-原材料清单列表
     * 
     * @param proRecordRawdet 生产管理-生产记录-原材料清单
     * @return 生产管理-生产记录-原材料清单集合
     */
    public List<ProRecordRawdet> selectProRecordRawdetList(ProRecordRawdet proRecordRawdet);

    /**
     * 新增生产管理-生产记录-原材料清单
     * 
     * @param proRecordRawdet 生产管理-生产记录-原材料清单
     * @return 结果
     */
    public int insertProRecordRawdet(ProRecordRawdet proRecordRawdet);

    /**
     * 修改生产管理-生产记录-原材料清单
     * 
     * @param proRecordRawdet 生产管理-生产记录-原材料清单
     * @return 结果
     */
    public int updateProRecordRawdet(ProRecordRawdet proRecordRawdet);

    /**
     * 批量删除生产管理-生产记录-原材料清单
     * 
     * @param rawdetIds 需要删除的生产管理-生产记录-原材料清单ID
     * @return 结果
     */
    public int deleteProRecordRawdetByIds(Long[] rawdetIds);

    /**
     * 删除生产管理-生产记录-原材料清单信息
     * 
     * @param rawdetId 生产管理-生产记录-原材料清单ID
     * @return 结果
     */
    public int deleteProRecordRawdetById(Long rawdetId);
}
