package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProRecord;

/**
 * 生产管理-生产记录Service接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface IProRecordService 
{
    /**
     * 查询生产管理-生产记录
     * 
     * @param recordId 生产管理-生产记录ID
     * @return 生产管理-生产记录
     */
    public ProRecord selectProRecordById(Long recordId);

    /**
     * 查询生产管理-生产记录列表
     * 
     * @param proRecord 生产管理-生产记录
     * @return 生产管理-生产记录集合
     */
    public List<ProRecord> selectProRecordList(ProRecord proRecord);

    /**
     * 新增生产管理-生产记录
     * 
     * @param proRecord 生产管理-生产记录
     * @return 结果
     */
    public int insertProRecord(ProRecord proRecord);

    /**
     * 修改生产管理-生产记录
     * 
     * @param proRecord 生产管理-生产记录
     * @return 结果
     */
    public int updateProRecord(ProRecord proRecord);

    /**
     * 批量删除生产管理-生产记录
     * 
     * @param recordIds 需要删除的生产管理-生产记录ID
     * @return 结果
     */
    public int deleteProRecordByIds(Long[] recordIds);

    /**
     * 删除生产管理-生产记录信息
     * 
     * @param recordId 生产管理-生产记录ID
     * @return 结果
     */
    public int deleteProRecordById(Long recordId);
}
