package com.ruoyi.project.cmplant.service;

import java.util.List;
import com.ruoyi.project.cmplant.domain.ProductionSjgl;

/**
 * 试验管理-试件管理Service接口
 * 
 * @author lihang
 * @date 2020-08-27
 */
public interface IProductionSjglService 
{
    /**
     * 查询试验管理-试件管理
     * 
     * @param sjglId 试验管理-试件管理ID
     * @return 试验管理-试件管理
     */
    public ProductionSjgl selectProductionSjglById(Long sjglId);

    /**
     * 查询试验管理-试件管理列表
     * 
     * @param productionSjgl 试验管理-试件管理
     * @return 试验管理-试件管理集合
     */
    public List<ProductionSjgl> selectProductionSjglList(ProductionSjgl productionSjgl);

    /**
     * 新增试验管理-试件管理
     * 
     * @param productionSjgl 试验管理-试件管理
     * @return 结果
     */
    public int insertProductionSjgl(ProductionSjgl productionSjgl);

    /**
     * 修改试验管理-试件管理
     * 
     * @param productionSjgl 试验管理-试件管理
     * @return 结果
     */
    public int updateProductionSjgl(ProductionSjgl productionSjgl);

    /**
     * 批量删除试验管理-试件管理
     * 
     * @param sjglIds 需要删除的试验管理-试件管理ID
     * @return 结果
     */
    public int deleteProductionSjglByIds(Long[] sjglIds);

    /**
     * 删除试验管理-试件管理信息
     * 
     * @param sjglId 试验管理-试件管理ID
     * @return 结果
     */
    public int deleteProductionSjglById(Long sjglId);
}
