package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProRecordMapper;
import com.ruoyi.project.cmplant.domain.ProRecord;
import com.ruoyi.project.cmplant.service.IProRecordService;

/**
 * 生产管理-生产记录Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProRecordServiceImpl implements IProRecordService 
{
    @Autowired
    private ProRecordMapper proRecordMapper;

    /**
     * 查询生产管理-生产记录
     * 
     * @param recordId 生产管理-生产记录ID
     * @return 生产管理-生产记录
     */
    @Override
    public ProRecord selectProRecordById(Long recordId)
    {
        return proRecordMapper.selectProRecordById(recordId);
    }

    /**
     * 查询生产管理-生产记录列表
     * 
     * @param proRecord 生产管理-生产记录
     * @return 生产管理-生产记录
     */
    @Override
    public List<ProRecord> selectProRecordList(ProRecord proRecord)
    {
        return proRecordMapper.selectProRecordList(proRecord);
    }

    /**
     * 新增生产管理-生产记录
     * 
     * @param proRecord 生产管理-生产记录
     * @return 结果
     */
    @Override
    public int insertProRecord(ProRecord proRecord)
    {
        proRecord.setCreateTime(DateUtils.getNowDate());
        return proRecordMapper.insertProRecord(proRecord);
    }

    /**
     * 修改生产管理-生产记录
     * 
     * @param proRecord 生产管理-生产记录
     * @return 结果
     */
    @Override
    public int updateProRecord(ProRecord proRecord)
    {
        proRecord.setUpdateTime(DateUtils.getNowDate());
        return proRecordMapper.updateProRecord(proRecord);
    }

    /**
     * 批量删除生产管理-生产记录
     * 
     * @param recordIds 需要删除的生产管理-生产记录ID
     * @return 结果
     */
    @Override
    public int deleteProRecordByIds(Long[] recordIds)
    {
        return proRecordMapper.deleteProRecordByIds(recordIds);
    }

    /**
     * 删除生产管理-生产记录信息
     * 
     * @param recordId 生产管理-生产记录ID
     * @return 结果
     */
    @Override
    public int deleteProRecordById(Long recordId)
    {
        return proRecordMapper.deleteProRecordById(recordId);
    }
}
