package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProStatisMapper;
import com.ruoyi.project.cmplant.domain.ProStatis;
import com.ruoyi.project.cmplant.service.IProStatisService;

/**
 * 生产管理-生产统计Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-28
 */
@Service
public class ProStatisServiceImpl implements IProStatisService 
{
    @Autowired
    private ProStatisMapper proStatisMapper;

    /**
     * 查询生产管理-生产统计
     * 
     * @param statisId 生产管理-生产统计ID
     * @return 生产管理-生产统计
     */
    @Override
    public ProStatis selectProStatisById(Long statisId)
    {
        return proStatisMapper.selectProStatisById(statisId);
    }

    /**
     * 查询生产管理-生产统计列表
     * 
     * @param proStatis 生产管理-生产统计
     * @return 生产管理-生产统计
     */
    @Override
    public List<ProStatis> selectProStatisList(ProStatis proStatis)
    {
        return proStatisMapper.selectProStatisList(proStatis);
    }

    /**
     * 新增生产管理-生产统计
     * 
     * @param proStatis 生产管理-生产统计
     * @return 结果
     */
    @Override
    public int insertProStatis(ProStatis proStatis)
    {
        proStatis.setCreateTime(DateUtils.getNowDate());
        return proStatisMapper.insertProStatis(proStatis);
    }

    /**
     * 修改生产管理-生产统计
     * 
     * @param proStatis 生产管理-生产统计
     * @return 结果
     */
    @Override
    public int updateProStatis(ProStatis proStatis)
    {
        proStatis.setUpdateTime(DateUtils.getNowDate());
        return proStatisMapper.updateProStatis(proStatis);
    }

    /**
     * 批量删除生产管理-生产统计
     * 
     * @param statisIds 需要删除的生产管理-生产统计ID
     * @return 结果
     */
    @Override
    public int deleteProStatisByIds(Long[] statisIds)
    {
        return proStatisMapper.deleteProStatisByIds(statisIds);
    }

    /**
     * 删除生产管理-生产统计信息
     * 
     * @param statisId 生产管理-生产统计ID
     * @return 结果
     */
    @Override
    public int deleteProStatisById(Long statisId)
    {
        return proStatisMapper.deleteProStatisById(statisId);
    }
}
