package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.ProTodoMapper;
import com.ruoyi.project.cmplant.domain.ProTodo;
import com.ruoyi.project.cmplant.service.IProTodoService;

/**
 * 生产管理-生产任务单Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class ProTodoServiceImpl implements IProTodoService 
{
    @Autowired
    private ProTodoMapper proTodoMapper;

    /**
     * 查询生产管理-生产任务单
     * 
     * @param todoId 生产管理-生产任务单ID
     * @return 生产管理-生产任务单
     */
    @Override
    public ProTodo selectProTodoById(Long todoId)
    {
        return proTodoMapper.selectProTodoById(todoId);
    }

    /**
     * 查询生产管理-生产任务单列表
     * 
     * @param proTodo 生产管理-生产任务单
     * @return 生产管理-生产任务单
     */
    @Override
    public List<ProTodo> selectProTodoList(ProTodo proTodo)
    {
        return proTodoMapper.selectProTodoList(proTodo);
    }

    /**
     * 新增生产管理-生产任务单
     * 
     * @param proTodo 生产管理-生产任务单
     * @return 结果
     */
    @Override
    public int insertProTodo(ProTodo proTodo)
    {
        proTodo.setCreateTime(DateUtils.getNowDate());
        return proTodoMapper.insertProTodo(proTodo);
    }

    /**
     * 修改生产管理-生产任务单
     * 
     * @param proTodo 生产管理-生产任务单
     * @return 结果
     */
    @Override
    public int updateProTodo(ProTodo proTodo)
    {
        proTodo.setUpdateTime(DateUtils.getNowDate());
        return proTodoMapper.updateProTodo(proTodo);
    }

    /**
     * 批量删除生产管理-生产任务单
     * 
     * @param todoIds 需要删除的生产管理-生产任务单ID
     * @return 结果
     */
    @Override
    public int deleteProTodoByIds(Long[] todoIds)
    {
        return proTodoMapper.deleteProTodoByIds(todoIds);
    }

    /**
     * 删除生产管理-生产任务单信息
     * 
     * @param todoId 生产管理-生产任务单ID
     * @return 结果
     */
    @Override
    public int deleteProTodoById(Long todoId)
    {
        return proTodoMapper.deleteProTodoById(todoId);
    }
}
