package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.TransportRwglMapper;
import com.ruoyi.project.cmplant.domain.TransportRwgl;
import com.ruoyi.project.cmplant.service.ITransportRwglService;

/**
 * 运输管理-任务管理Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class TransportRwglServiceImpl implements ITransportRwglService 
{
    @Autowired
    private TransportRwglMapper transportRwglMapper;

    /**
     * 查询运输管理-任务管理
     * 
     * @param rwglId 运输管理-任务管理ID
     * @return 运输管理-任务管理
     */
    @Override
    public TransportRwgl selectTransportRwglById(Long rwglId)
    {
        return transportRwglMapper.selectTransportRwglById(rwglId);
    }

    /**
     * 查询运输管理-任务管理列表
     * 
     * @param transportRwgl 运输管理-任务管理
     * @return 运输管理-任务管理
     */
    @Override
    public List<TransportRwgl> selectTransportRwglList(TransportRwgl transportRwgl)
    {
        return transportRwglMapper.selectTransportRwglList(transportRwgl);
    }

    /**
     * 新增运输管理-任务管理
     * 
     * @param transportRwgl 运输管理-任务管理
     * @return 结果
     */
    @Override
    public int insertTransportRwgl(TransportRwgl transportRwgl)
    {
        transportRwgl.setCreateTime(DateUtils.getNowDate());
        return transportRwglMapper.insertTransportRwgl(transportRwgl);
    }

    /**
     * 修改运输管理-任务管理
     * 
     * @param transportRwgl 运输管理-任务管理
     * @return 结果
     */
    @Override
    public int updateTransportRwgl(TransportRwgl transportRwgl)
    {
        transportRwgl.setUpdateTime(DateUtils.getNowDate());
        return transportRwglMapper.updateTransportRwgl(transportRwgl);
    }

    /**
     * 批量删除运输管理-任务管理
     * 
     * @param rwglIds 需要删除的运输管理-任务管理ID
     * @return 结果
     */
    @Override
    public int deleteTransportRwglByIds(Long[] rwglIds)
    {
        return transportRwglMapper.deleteTransportRwglByIds(rwglIds);
    }

    /**
     * 删除运输管理-任务管理信息
     * 
     * @param rwglId 运输管理-任务管理ID
     * @return 结果
     */
    @Override
    public int deleteTransportRwglById(Long rwglId)
    {
        return transportRwglMapper.deleteTransportRwglById(rwglId);
    }
}
