package com.ruoyi.project.cmplant.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.cmplant.mapper.TransportYsjlMapper;
import com.ruoyi.project.cmplant.domain.TransportYsjl;
import com.ruoyi.project.cmplant.service.ITransportYsjlService;

/**
 * 运输管理-运输监测Service业务层处理
 * 
 * @author lihang
 * @date 2020-08-27
 */
@Service
public class TransportYsjlServiceImpl implements ITransportYsjlService 
{
    @Autowired
    private TransportYsjlMapper transportYsjlMapper;

    /**
     * 查询运输管理-运输监测
     * 
     * @param ysjcId 运输管理-运输监测ID
     * @return 运输管理-运输监测
     */
    @Override
    public TransportYsjl selectTransportYsjlById(Long ysjcId)
    {
        return transportYsjlMapper.selectTransportYsjlById(ysjcId);
    }

    /**
     * 查询运输管理-运输监测列表
     * 
     * @param transportYsjl 运输管理-运输监测
     * @return 运输管理-运输监测
     */
    @Override
    public List<TransportYsjl> selectTransportYsjlList(TransportYsjl transportYsjl)
    {
        return transportYsjlMapper.selectTransportYsjlList(transportYsjl);
    }

    /**
     * 新增运输管理-运输监测
     * 
     * @param transportYsjl 运输管理-运输监测
     * @return 结果
     */
    @Override
    public int insertTransportYsjl(TransportYsjl transportYsjl)
    {
        transportYsjl.setCreateTime(DateUtils.getNowDate());
        return transportYsjlMapper.insertTransportYsjl(transportYsjl);
    }

    /**
     * 修改运输管理-运输监测
     * 
     * @param transportYsjl 运输管理-运输监测
     * @return 结果
     */
    @Override
    public int updateTransportYsjl(TransportYsjl transportYsjl)
    {
        transportYsjl.setUpdateTime(DateUtils.getNowDate());
        return transportYsjlMapper.updateTransportYsjl(transportYsjl);
    }

    /**
     * 批量删除运输管理-运输监测
     * 
     * @param ysjcIds 需要删除的运输管理-运输监测ID
     * @return 结果
     */
    @Override
    public int deleteTransportYsjlByIds(Long[] ysjcIds)
    {
        return transportYsjlMapper.deleteTransportYsjlByIds(ysjcIds);
    }

    /**
     * 删除运输管理-运输监测信息
     * 
     * @param ysjcId 运输管理-运输监测ID
     * @return 结果
     */
    @Override
    public int deleteTransportYsjlById(Long ysjcId)
    {
        return transportYsjlMapper.deleteTransportYsjlById(ysjcId);
    }
}
