package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.BainfoStaff;
import com.ruoyi.project.cmplant.service.IBainfoStaffService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 基础信息-人员管理Controller
 * 
 * @author lihang
 * @date 2020-08-26
 */
@RestController
@RequestMapping("/cmplant/staff")
public class BainfoStaffController extends BaseController
{
    @Autowired
    private IBainfoStaffService bainfoStaffService;

    /**
     * 查询基础信息-人员管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:staff:list')")
    @GetMapping("/list")
    public TableDataInfo list(BainfoStaff bainfoStaff)
    {
        startPage();
        List<BainfoStaff> list = bainfoStaffService.selectBainfoStaffList(bainfoStaff);
        return getDataTable(list);
    }

    /**
     * 导出基础信息-人员管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:staff:export')")
    @Log(title = "基础信息-人员管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(BainfoStaff bainfoStaff)
    {
        List<BainfoStaff> list = bainfoStaffService.selectBainfoStaffList(bainfoStaff);
        ExcelUtil<BainfoStaff> util = new ExcelUtil<BainfoStaff>(BainfoStaff.class);
        return util.exportExcel(list, "staff");
    }

    /**
     * 获取基础信息-人员管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:staff:query')")
    @GetMapping(value = "/{staffId}")
    public AjaxResult getInfo(@PathVariable("staffId") Long staffId)
    {
        return AjaxResult.success(bainfoStaffService.selectBainfoStaffById(staffId));
    }

    /**
     * 新增基础信息-人员管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:staff:add')")
    @Log(title = "基础信息-人员管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody BainfoStaff bainfoStaff)
    {
        return toAjax(bainfoStaffService.insertBainfoStaff(bainfoStaff));
    }

    /**
     * 修改基础信息-人员管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:staff:edit')")
    @Log(title = "基础信息-人员管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody BainfoStaff bainfoStaff)
    {
        return toAjax(bainfoStaffService.updateBainfoStaff(bainfoStaff));
    }

    /**
     * 删除基础信息-人员管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:staff:remove')")
    @Log(title = "基础信息-人员管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{staffIds}")
    public AjaxResult remove(@PathVariable Long[] staffIds)
    {
        return toAjax(bainfoStaffService.deleteBainfoStaffByIds(staffIds));
    }
}
