package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProDatmon;
import com.ruoyi.project.cmplant.service.IProDatmonService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-数据监测Controller
 * 
 * @author lihang
 * @date 2020-08-28
 */
@RestController
@RequestMapping("/cmplant/datmon")
public class ProDatmonController extends BaseController
{
    @Autowired
    private IProDatmonService proDatmonService;

    /**
     * 查询生产管理-数据监测列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:datmon:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProDatmon proDatmon)
    {
        startPage();
        List<ProDatmon> list = proDatmonService.selectProDatmonList(proDatmon);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-数据监测列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:datmon:export')")
    @Log(title = "生产管理-数据监测", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProDatmon proDatmon)
    {
        List<ProDatmon> list = proDatmonService.selectProDatmonList(proDatmon);
        ExcelUtil<ProDatmon> util = new ExcelUtil<ProDatmon>(ProDatmon.class);
        return util.exportExcel(list, "datmon");
    }

    /**
     * 获取生产管理-数据监测详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:datmon:query')")
    @GetMapping(value = "/{damonId}")
    public AjaxResult getInfo(@PathVariable("damonId") Long damonId)
    {
        return AjaxResult.success(proDatmonService.selectProDatmonById(damonId));
    }

    /**
     * 新增生产管理-数据监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:datmon:add')")
    @Log(title = "生产管理-数据监测", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProDatmon proDatmon)
    {
        return toAjax(proDatmonService.insertProDatmon(proDatmon));
    }

    /**
     * 修改生产管理-数据监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:datmon:edit')")
    @Log(title = "生产管理-数据监测", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProDatmon proDatmon)
    {
        return toAjax(proDatmonService.updateProDatmon(proDatmon));
    }

    /**
     * 删除生产管理-数据监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:datmon:remove')")
    @Log(title = "生产管理-数据监测", businessType = BusinessType.DELETE)
	@DeleteMapping("/{damonIds}")
    public AjaxResult remove(@PathVariable Long[] damonIds)
    {
        return toAjax(proDatmonService.deleteProDatmonByIds(damonIds));
    }
}
