package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProEnmon;
import com.ruoyi.project.cmplant.service.IProEnmonService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-环境监测Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/enmon")
public class ProEnmonController extends BaseController
{
    @Autowired
    private IProEnmonService proEnmonService;

    /**
     * 查询生产管理-环境监测列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:enmon:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProEnmon proEnmon)
    {
        startPage();
        List<ProEnmon> list = proEnmonService.selectProEnmonList(proEnmon);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-环境监测列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:enmon:export')")
    @Log(title = "生产管理-环境监测", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProEnmon proEnmon)
    {
        List<ProEnmon> list = proEnmonService.selectProEnmonList(proEnmon);
        ExcelUtil<ProEnmon> util = new ExcelUtil<ProEnmon>(ProEnmon.class);
        return util.exportExcel(list, "enmon");
    }

    /**
     * 获取生产管理-环境监测详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:enmon:query')")
    @GetMapping(value = "/{enmonId}")
    public AjaxResult getInfo(@PathVariable("enmonId") Long enmonId)
    {
        return AjaxResult.success(proEnmonService.selectProEnmonById(enmonId));
    }

    /**
     * 新增生产管理-环境监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:enmon:add')")
    @Log(title = "生产管理-环境监测", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProEnmon proEnmon)
    {
        return toAjax(proEnmonService.insertProEnmon(proEnmon));
    }

    /**
     * 修改生产管理-环境监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:enmon:edit')")
    @Log(title = "生产管理-环境监测", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProEnmon proEnmon)
    {
        return toAjax(proEnmonService.updateProEnmon(proEnmon));
    }

    /**
     * 删除生产管理-环境监测
     */
    @PreAuthorize("@ss.hasPermi('cmplant:enmon:remove')")
    @Log(title = "生产管理-环境监测", businessType = BusinessType.DELETE)
	@DeleteMapping("/{enmonIds}")
    public AjaxResult remove(@PathVariable Long[] enmonIds)
    {
        return toAjax(proEnmonService.deleteProEnmonByIds(enmonIds));
    }
}
