package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProRecordRawdet;
import com.ruoyi.project.cmplant.service.IProRecordRawdetService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-生产记录-原材料清单Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/rawdet")
public class ProRecordRawdetController extends BaseController
{
    @Autowired
    private IProRecordRawdetService proRecordRawdetService;

    /**
     * 查询生产管理-生产记录-原材料清单列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rawdet:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProRecordRawdet proRecordRawdet)
    {
        startPage();
        List<ProRecordRawdet> list = proRecordRawdetService.selectProRecordRawdetList(proRecordRawdet);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-生产记录-原材料清单列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rawdet:export')")
    @Log(title = "生产管理-生产记录-原材料清单", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProRecordRawdet proRecordRawdet)
    {
        List<ProRecordRawdet> list = proRecordRawdetService.selectProRecordRawdetList(proRecordRawdet);
        ExcelUtil<ProRecordRawdet> util = new ExcelUtil<ProRecordRawdet>(ProRecordRawdet.class);
        return util.exportExcel(list, "rawdet");
    }

    /**
     * 获取生产管理-生产记录-原材料清单详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rawdet:query')")
    @GetMapping(value = "/{rawdetId}")
    public AjaxResult getInfo(@PathVariable("rawdetId") Long rawdetId)
    {
        return AjaxResult.success(proRecordRawdetService.selectProRecordRawdetById(rawdetId));
    }

    /**
     * 新增生产管理-生产记录-原材料清单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rawdet:add')")
    @Log(title = "生产管理-生产记录-原材料清单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProRecordRawdet proRecordRawdet)
    {
        return toAjax(proRecordRawdetService.insertProRecordRawdet(proRecordRawdet));
    }

    /**
     * 修改生产管理-生产记录-原材料清单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rawdet:edit')")
    @Log(title = "生产管理-生产记录-原材料清单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProRecordRawdet proRecordRawdet)
    {
        return toAjax(proRecordRawdetService.updateProRecordRawdet(proRecordRawdet));
    }

    /**
     * 删除生产管理-生产记录-原材料清单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rawdet:remove')")
    @Log(title = "生产管理-生产记录-原材料清单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{rawdetIds}")
    public AjaxResult remove(@PathVariable Long[] rawdetIds)
    {
        return toAjax(proRecordRawdetService.deleteProRecordRawdetByIds(rawdetIds));
    }
}
