package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProSales;
import com.ruoyi.project.cmplant.service.IProSalesService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 生产管理-销售订单Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/sales")
public class ProSalesController extends BaseController
{
    @Autowired
    private IProSalesService proSalesService;

    /**
     * 查询生产管理-销售订单列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sales:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProSales proSales)
    {
        startPage();
        List<ProSales> list = proSalesService.selectProSalesList(proSales);
        return getDataTable(list);
    }

    /**
     * 导出生产管理-销售订单列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sales:export')")
    @Log(title = "生产管理-销售订单", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProSales proSales)
    {
        List<ProSales> list = proSalesService.selectProSalesList(proSales);
        ExcelUtil<ProSales> util = new ExcelUtil<ProSales>(ProSales.class);
        return util.exportExcel(list, "sales");
    }

    /**
     * 获取生产管理-销售订单详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sales:query')")
    @GetMapping(value = "/{salesId}")
    public AjaxResult getInfo(@PathVariable("salesId") Long salesId)
    {
        return AjaxResult.success(proSalesService.selectProSalesById(salesId));
    }

    /**
     * 新增生产管理-销售订单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sales:add')")
    @Log(title = "生产管理-销售订单", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProSales proSales)
    {
        return toAjax(proSalesService.insertProSales(proSales));
    }

    /**
     * 修改生产管理-销售订单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sales:edit')")
    @Log(title = "生产管理-销售订单", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProSales proSales)
    {
        return toAjax(proSalesService.updateProSales(proSales));
    }

    /**
     * 删除生产管理-销售订单
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sales:remove')")
    @Log(title = "生产管理-销售订单", businessType = BusinessType.DELETE)
	@DeleteMapping("/{salesIds}")
    public AjaxResult remove(@PathVariable Long[] salesIds)
    {
        return toAjax(proSalesService.deleteProSalesByIds(salesIds));
    }
}
