package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProductionPhbgl;
import com.ruoyi.project.cmplant.service.IProductionPhbglService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 试验管理-配合比管理Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/phbgl")
public class ProductionPhbglController extends BaseController
{
    @Autowired
    private IProductionPhbglService productionPhbglService;

    /**
     * 查询试验管理-配合比管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:phbgl:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProductionPhbgl productionPhbgl)
    {
        startPage();
        List<ProductionPhbgl> list = productionPhbglService.selectProductionPhbglList(productionPhbgl);
        return getDataTable(list);
    }

    /**
     * 导出试验管理-配合比管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:phbgl:export')")
    @Log(title = "试验管理-配合比管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProductionPhbgl productionPhbgl)
    {
        List<ProductionPhbgl> list = productionPhbglService.selectProductionPhbglList(productionPhbgl);
        ExcelUtil<ProductionPhbgl> util = new ExcelUtil<ProductionPhbgl>(ProductionPhbgl.class);
        return util.exportExcel(list, "phbgl");
    }

    /**
     * 获取试验管理-配合比管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:phbgl:query')")
    @GetMapping(value = "/{phbglId}")
    public AjaxResult getInfo(@PathVariable("phbglId") Long phbglId)
    {
        return AjaxResult.success(productionPhbglService.selectProductionPhbglById(phbglId));
    }

    /**
     * 新增试验管理-配合比管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:phbgl:add')")
    @Log(title = "试验管理-配合比管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProductionPhbgl productionPhbgl)
    {
        return toAjax(productionPhbglService.insertProductionPhbgl(productionPhbgl));
    }

    /**
     * 修改试验管理-配合比管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:phbgl:edit')")
    @Log(title = "试验管理-配合比管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProductionPhbgl productionPhbgl)
    {
        return toAjax(productionPhbglService.updateProductionPhbgl(productionPhbgl));
    }

    /**
     * 删除试验管理-配合比管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:phbgl:remove')")
    @Log(title = "试验管理-配合比管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{phbglIds}")
    public AjaxResult remove(@PathVariable Long[] phbglIds)
    {
        return toAjax(productionPhbglService.deleteProductionPhbglByIds(phbglIds));
    }
}
