package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProductionSjgl;
import com.ruoyi.project.cmplant.service.IProductionSjglService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 试验管理-试件管理Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/sjgl")
public class ProductionSjglController extends BaseController
{
    @Autowired
    private IProductionSjglService productionSjglService;

    /**
     * 查询试验管理-试件管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sjgl:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProductionSjgl productionSjgl)
    {
        startPage();
        List<ProductionSjgl> list = productionSjglService.selectProductionSjglList(productionSjgl);
        return getDataTable(list);
    }

    /**
     * 导出试验管理-试件管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sjgl:export')")
    @Log(title = "试验管理-试件管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProductionSjgl productionSjgl)
    {
        List<ProductionSjgl> list = productionSjglService.selectProductionSjglList(productionSjgl);
        ExcelUtil<ProductionSjgl> util = new ExcelUtil<ProductionSjgl>(ProductionSjgl.class);
        return util.exportExcel(list, "sjgl");
    }

    /**
     * 获取试验管理-试件管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sjgl:query')")
    @GetMapping(value = "/{sjglId}")
    public AjaxResult getInfo(@PathVariable("sjglId") Long sjglId)
    {
        return AjaxResult.success(productionSjglService.selectProductionSjglById(sjglId));
    }

    /**
     * 新增试验管理-试件管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sjgl:add')")
    @Log(title = "试验管理-试件管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProductionSjgl productionSjgl)
    {
        return toAjax(productionSjglService.insertProductionSjgl(productionSjgl));
    }

    /**
     * 修改试验管理-试件管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sjgl:edit')")
    @Log(title = "试验管理-试件管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProductionSjgl productionSjgl)
    {
        return toAjax(productionSjglService.updateProductionSjgl(productionSjgl));
    }

    /**
     * 删除试验管理-试件管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sjgl:remove')")
    @Log(title = "试验管理-试件管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{sjglIds}")
    public AjaxResult remove(@PathVariable Long[] sjglIds)
    {
        return toAjax(productionSjglService.deleteProductionSjglByIds(sjglIds));
    }
}
