package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.ProductionSy;
import com.ruoyi.project.cmplant.service.IProductionSyService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 试验管理-溯源Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/sy")
public class ProductionSyController extends BaseController
{
    @Autowired
    private IProductionSyService productionSyService;

    /**
     * 查询试验管理-溯源列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sy:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProductionSy productionSy)
    {
        startPage();
        List<ProductionSy> list = productionSyService.selectProductionSyList(productionSy);
        return getDataTable(list);
    }

    /**
     * 导出试验管理-溯源列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sy:export')")
    @Log(title = "试验管理-溯源", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(ProductionSy productionSy)
    {
        List<ProductionSy> list = productionSyService.selectProductionSyList(productionSy);
        ExcelUtil<ProductionSy> util = new ExcelUtil<ProductionSy>(ProductionSy.class);
        return util.exportExcel(list, "sy");
    }

    /**
     * 获取试验管理-溯源详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sy:query')")
    @GetMapping(value = "/{syId}")
    public AjaxResult getInfo(@PathVariable("syId") Long syId)
    {
        return AjaxResult.success(productionSyService.selectProductionSyById(syId));
    }

    /**
     * 新增试验管理-溯源
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sy:add')")
    @Log(title = "试验管理-溯源", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProductionSy productionSy)
    {
        return toAjax(productionSyService.insertProductionSy(productionSy));
    }

    /**
     * 修改试验管理-溯源
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sy:edit')")
    @Log(title = "试验管理-溯源", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProductionSy productionSy)
    {
        return toAjax(productionSyService.updateProductionSy(productionSy));
    }

    /**
     * 删除试验管理-溯源
     */
    @PreAuthorize("@ss.hasPermi('cmplant:sy:remove')")
    @Log(title = "试验管理-溯源", businessType = BusinessType.DELETE)
	@DeleteMapping("/{syIds}")
    public AjaxResult remove(@PathVariable Long[] syIds)
    {
        return toAjax(productionSyService.deleteProductionSyByIds(syIds));
    }
}
