package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.TransportRwgl;
import com.ruoyi.project.cmplant.service.ITransportRwglService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 运输管理-任务管理Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/rwgl")
public class TransportRwglController extends BaseController
{
    @Autowired
    private ITransportRwglService transportRwglService;

    /**
     * 查询运输管理-任务管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rwgl:list')")
    @GetMapping("/list")
    public TableDataInfo list(TransportRwgl transportRwgl)
    {
        startPage();
        List<TransportRwgl> list = transportRwglService.selectTransportRwglList(transportRwgl);
        return getDataTable(list);
    }

    /**
     * 导出运输管理-任务管理列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rwgl:export')")
    @Log(title = "运输管理-任务管理", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TransportRwgl transportRwgl)
    {
        List<TransportRwgl> list = transportRwglService.selectTransportRwglList(transportRwgl);
        ExcelUtil<TransportRwgl> util = new ExcelUtil<TransportRwgl>(TransportRwgl.class);
        return util.exportExcel(list, "rwgl");
    }

    /**
     * 获取运输管理-任务管理详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rwgl:query')")
    @GetMapping(value = "/{rwglId}")
    public AjaxResult getInfo(@PathVariable("rwglId") Long rwglId)
    {
        return AjaxResult.success(transportRwglService.selectTransportRwglById(rwglId));
    }

    /**
     * 新增运输管理-任务管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rwgl:add')")
    @Log(title = "运输管理-任务管理", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TransportRwgl transportRwgl)
    {
        return toAjax(transportRwglService.insertTransportRwgl(transportRwgl));
    }

    /**
     * 修改运输管理-任务管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rwgl:edit')")
    @Log(title = "运输管理-任务管理", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TransportRwgl transportRwgl)
    {
        return toAjax(transportRwglService.updateTransportRwgl(transportRwgl));
    }

    /**
     * 删除运输管理-任务管理
     */
    @PreAuthorize("@ss.hasPermi('cmplant:rwgl:remove')")
    @Log(title = "运输管理-任务管理", businessType = BusinessType.DELETE)
	@DeleteMapping("/{rwglIds}")
    public AjaxResult remove(@PathVariable Long[] rwglIds)
    {
        return toAjax(transportRwglService.deleteTransportRwglByIds(rwglIds));
    }
}
