package com.ruoyi.project.cmplant.controller;

import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.cmplant.domain.TransportYslxsz;
import com.ruoyi.project.cmplant.service.ITransportYslxszService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 运输管理-运输路线设置Controller
 * 
 * @author lihang
 * @date 2020-08-27
 */
@RestController
@RequestMapping("/cmplant/yslxsz")
public class TransportYslxszController extends BaseController
{
    @Autowired
    private ITransportYslxszService transportYslxszService;

    /**
     * 查询运输管理-运输路线设置列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:yslxsz:list')")
    @GetMapping("/list")
    public TableDataInfo list(TransportYslxsz transportYslxsz)
    {
        startPage();
        List<TransportYslxsz> list = transportYslxszService.selectTransportYslxszList(transportYslxsz);
        return getDataTable(list);
    }

    /**
     * 导出运输管理-运输路线设置列表
     */
    @PreAuthorize("@ss.hasPermi('cmplant:yslxsz:export')")
    @Log(title = "运输管理-运输路线设置", businessType = BusinessType.EXPORT)
    @GetMapping("/export")
    public AjaxResult export(TransportYslxsz transportYslxsz)
    {
        List<TransportYslxsz> list = transportYslxszService.selectTransportYslxszList(transportYslxsz);
        ExcelUtil<TransportYslxsz> util = new ExcelUtil<TransportYslxsz>(TransportYslxsz.class);
        return util.exportExcel(list, "yslxsz");
    }

    /**
     * 获取运输管理-运输路线设置详细信息
     */
    @PreAuthorize("@ss.hasPermi('cmplant:yslxsz:query')")
    @GetMapping(value = "/{yslxszId}")
    public AjaxResult getInfo(@PathVariable("yslxszId") Long yslxszId)
    {
        return AjaxResult.success(transportYslxszService.selectTransportYslxszById(yslxszId));
    }

    /**
     * 新增运输管理-运输路线设置
     */
    @PreAuthorize("@ss.hasPermi('cmplant:yslxsz:add')")
    @Log(title = "运输管理-运输路线设置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody TransportYslxsz transportYslxsz)
    {
        return toAjax(transportYslxszService.insertTransportYslxsz(transportYslxsz));
    }

    /**
     * 修改运输管理-运输路线设置
     */
    @PreAuthorize("@ss.hasPermi('cmplant:yslxsz:edit')")
    @Log(title = "运输管理-运输路线设置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody TransportYslxsz transportYslxsz)
    {
        return toAjax(transportYslxszService.updateTransportYslxsz(transportYslxsz));
    }

    /**
     * 删除运输管理-运输路线设置
     */
    @PreAuthorize("@ss.hasPermi('cmplant:yslxsz:remove')")
    @Log(title = "运输管理-运输路线设置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{yslxszIds}")
    public AjaxResult remove(@PathVariable Long[] yslxszIds)
    {
        return toAjax(transportYslxszService.deleteTransportYslxszByIds(yslxszIds));
    }
}
