package com.ruoyi.project.cmplant.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 基础信息-企业资质对象 bainfo_encert
 * 
 * @author lihang
 * @date 2020-08-26
 */
public class BainfoEncert extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 企业资质主键ID */
    private Long encertId;

    /** 企业信息主键ID（关联主键） */
    @Excel(name = "企业信息主键ID", readConverterExp = "关=联主键")
    private Long eninfoId;

    /** 企业执照 */
    @Excel(name = "企业执照")
    private String encertBulicen;

    /** 环评 */
    @Excel(name = "环评")
    private String encertEia;

    /** 计量认证 */
    @Excel(name = "计量认证")
    private String encertMecert;

    /** 建筑企业资质证 */
    @Excel(name = "建筑企业资质证")
    private String encertQualcert;

    /** 砼专项实验室资质 */
    @Excel(name = "砼专项实验室资质")
    private String encertLabocert;

    /** 状态 0删除 1保存 */
    @Excel(name = "状态 0删除 1保存")
    private Integer status;

    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }
    public void setEncertId(Long encertId) 
    {
        this.encertId = encertId;
    }

    public Long getEncertId() 
    {
        return encertId;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setEncertBulicen(String encertBulicen) 
    {
        this.encertBulicen = encertBulicen;
    }

    public String getEncertBulicen() 
    {
        return encertBulicen;
    }
    public void setEncertEia(String encertEia) 
    {
        this.encertEia = encertEia;
    }

    public String getEncertEia() 
    {
        return encertEia;
    }
    public void setEncertMecert(String encertMecert) 
    {
        this.encertMecert = encertMecert;
    }

    public String getEncertMecert() 
    {
        return encertMecert;
    }
    public void setEncertQualcert(String encertQualcert) 
    {
        this.encertQualcert = encertQualcert;
    }

    public String getEncertQualcert() 
    {
        return encertQualcert;
    }
    public void setEncertLabocert(String encertLabocert) 
    {
        this.encertLabocert = encertLabocert;
    }

    public String getEncertLabocert() 
    {
        return encertLabocert;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("encertId", getEncertId())
            .append("eninfoId", getEninfoId())
            .append("encertBulicen", getEncertBulicen())
            .append("encertEia", getEncertEia())
            .append("encertMecert", getEncertMecert())
            .append("encertQualcert", getEncertQualcert())
            .append("encertLabocert", getEncertLabocert())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
