package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 基础信息-企业信息对象 bainfo_eninfo
 * 
 * @author lihang
 * @date 2020-08-26
 */
public class BainfoEninfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 企业信息主键ID */
    private Long eninfoId;

    /** 行政区划编码 */
    @Excel(name = "行政区划编码")
    private String xzqhbm;

    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;

    /** 详细地址 */
    @Excel(name = "详细地址")
    private String eninfoAddress;

    /** 统一社会信用代码 */
    @Excel(name = "统一社会信用代码")
    private String eninfoCrecode;

    /** 成立日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "成立日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date setupTime;

    /** 营业开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "营业开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dobuCreatime;

    /** 营业结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "营业结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date dobuEndtime;

    /** 经营状态 */
    @Excel(name = "经营状态 1在业 2续存 3吊销 4注销 5迁入 6迁出 7停业 8结算")
    private Integer manageStatus;

    /** 电话 */
    @Excel(name = "电话")
    private String eninfoPhone;

    /** 商品混泥土年产量 */
    @Excel(name = "商品混泥土年产量")
    private Long eninfoYield;

    /** 平面照 */
    @Excel(name = "平面照")
    private String eninfoPhotos;

    /** 经度 */
    @Excel(name = "经度")
    private Double eninfoLon;

    /** 纬度 */
    @Excel(name = "纬度")
    private Double eninfoLat;

    /** 状态 0删除 1保存 2上报 */
    @Excel(name = "状态 0删除 1保存 2上报")
    private Integer status;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setXzqhbm(String xzqhbm) 
    {
        this.xzqhbm = xzqhbm;
    }

    public String getXzqhbm() 
    {
        return xzqhbm;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }
    public void setEninfoAddress(String eninfoAddress) 
    {
        this.eninfoAddress = eninfoAddress;
    }

    public String getEninfoAddress() 
    {
        return eninfoAddress;
    }
    public void setEninfoCrecode(String eninfoCrecode) 
    {
        this.eninfoCrecode = eninfoCrecode;
    }

    public String getEninfoCrecode() 
    {
        return eninfoCrecode;
    }
    public void setSetupTime(Date setupTime) 
    {
        this.setupTime = setupTime;
    }

    public Date getSetupTime() 
    {
        return setupTime;
    }
    public void setDobuCreatime(Date dobuCreatime) 
    {
        this.dobuCreatime = dobuCreatime;
    }

    public Date getDobuCreatime() 
    {
        return dobuCreatime;
    }
    public void setDobuEndtime(Date dobuEndtime) 
    {
        this.dobuEndtime = dobuEndtime;
    }

    public Date getDobuEndtime() 
    {
        return dobuEndtime;
    }
    public void setManageStatus(Integer manageStatus) 
    {
        this.manageStatus = manageStatus;
    }

    public Integer getManageStatus() 
    {
        return manageStatus;
    }
    public void setEninfoPhone(String eninfoPhone) 
    {
        this.eninfoPhone = eninfoPhone;
    }

    public String getEninfoPhone() 
    {
        return eninfoPhone;
    }
    public void setEninfoYield(Long eninfoYield) 
    {
        this.eninfoYield = eninfoYield;
    }

    public Long getEninfoYield() 
    {
        return eninfoYield;
    }
    public void setEninfoPhotos(String eninfoPhotos) 
    {
        this.eninfoPhotos = eninfoPhotos;
    }

    public String getEninfoPhotos() 
    {
        return eninfoPhotos;
    }
    public void setEninfoLon(Double eninfoLon) 
    {
        this.eninfoLon = eninfoLon;
    }

    public Double getEninfoLon() 
    {
        return eninfoLon;
    }
    public void setEninfoLat(Double eninfoLat) 
    {
        this.eninfoLat = eninfoLat;
    }

    public Double getEninfoLat() 
    {
        return eninfoLat;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("eninfoId", getEninfoId())
            .append("xzqhbm", getXzqhbm())
            .append("eninfoName", getEninfoName())
            .append("eninfoAddress", getEninfoAddress())
            .append("eninfoCrecode", getEninfoCrecode())
            .append("setupTime", getSetupTime())
            .append("dobuCreatime", getDobuCreatime())
            .append("dobuEndtime", getDobuEndtime())
            .append("manageStatus", getManageStatus())
            .append("eninfoPhone", getEninfoPhone())
            .append("eninfoYield", getEninfoYield())
            .append("eninfoPhotos", getEninfoPhotos())
            .append("eninfoLon", getEninfoLon())
            .append("eninfoLat", getEninfoLat())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
