package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 基础信息-搅拌站管理对象 bainfo_miplant
 * 
 * @author lihang
 * @date 2020-08-26
 */
public class BainfoMiplant extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 搅拌站主键ID */
    private Long miplantId;

    /** 企业信息主键ID（关联主键） */
    @Excel(name = "企业信息主键ID", readConverterExp = "关=联主键")
    private Long eninfoId;

    /** 搅拌站名称 */
    @Excel(name = "搅拌站名称")
    private String miplantName;

    /** 搅拌站型号 */
    @Excel(name = "搅拌站型号")
    private String miplantModel;

    /** 搅拌站类型 */
    @Excel(name = "搅拌站类型")
    private String miplantType;

    /** 规格 */
    @Excel(name = "规格")
    private String miplantSpeci;

    /** 生产率 */
    @Excel(name = "生产率")
    private Double miplantProdu;

    /** 搅拌站状态 0停用 1在用 2维修 */
    @Excel(name = "搅拌站状态 0停用 1在用 2维修")
    private Integer miplantStatus;

    /** 采购日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "采购日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date miplantProtime;

    /** 制造厂家 */
    @Excel(name = "制造厂家")
    private String miplantManu;

    /** 状态 0删除 1保存 */
    @Excel(name = "状态 0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}

	public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }
    public void setMiplantId(Long miplantId) 
    {
        this.miplantId = miplantId;
    }

    public Long getMiplantId() 
    {
        return miplantId;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setMiplantName(String miplantName) 
    {
        this.miplantName = miplantName;
    }

    public String getMiplantName() 
    {
        return miplantName;
    }
    public void setMiplantModel(String miplantModel) 
    {
        this.miplantModel = miplantModel;
    }

    public String getMiplantModel() 
    {
        return miplantModel;
    }
    public void setMiplantType(String miplantType) 
    {
        this.miplantType = miplantType;
    }

    public String getMiplantType() 
    {
        return miplantType;
    }
    public void setMiplantSpeci(String miplantSpeci) 
    {
        this.miplantSpeci = miplantSpeci;
    }

    public String getMiplantSpeci() 
    {
        return miplantSpeci;
    }
    public void setMiplantProdu(Double miplantProdu) 
    {
        this.miplantProdu = miplantProdu;
    }

    public Double getMiplantProdu() 
    {
        return miplantProdu;
    }
    public void setMiplantStatus(Integer miplantStatus) 
    {
        this.miplantStatus = miplantStatus;
    }

    public Integer getMiplantStatus() 
    {
        return miplantStatus;
    }
    public void setMiplantProtime(Date miplantProtime) 
    {
        this.miplantProtime = miplantProtime;
    }

    public Date getMiplantProtime() 
    {
        return miplantProtime;
    }
    public void setMiplantManu(String miplantManu) 
    {
        this.miplantManu = miplantManu;
    }

    public String getMiplantManu() 
    {
        return miplantManu;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("miplantId", getMiplantId())
            .append("eninfoId", getEninfoId())
            .append("miplantName", getMiplantName())
            .append("miplantModel", getMiplantModel())
            .append("miplantType", getMiplantType())
            .append("miplantSpeci", getMiplantSpeci())
            .append("miplantProdu", getMiplantProdu())
            .append("miplantStatus", getMiplantStatus())
            .append("miplantProtime", getMiplantProtime())
            .append("miplantManu", getMiplantManu())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
