package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 生产管理-环境监测对象 pro_enmon
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class ProEnmon extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 环境监测主键ID */
    private Long enmonId;

    /** 企业信息主键ID */
    @Excel(name = "企业信息主键ID")
    private Long eninfoId;

    /** 检测日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "检测日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date enmonDetetime;

    /** PM 10 */
    @Excel(name = "PM 10")
    private Double enmonPm10;

    /** PM 10 参考值 */
    @Excel(name = "PM 10 参考值")
    private Double enmonPm10Refer;

    /** PM 2.5 */
    @Excel(name = "PM 2.5")
    private Double enmonPm25;

    /** PM 2.5 参考值 */
    @Excel(name = "PM 2.5 参考值")
    private Double enmonPm25Refer;

    /** 噪音 */
    @Excel(name = "噪音")
    private Double enmonNoise;

    /** 噪音参考值 */
    @Excel(name = "噪音参考值")
    private Double enmonNoiseRefer;

    /** 状态 0删除 1保存 */
    @Excel(name = "状态 0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }

    public void setEnmonId(Long enmonId) 
    {
        this.enmonId = enmonId;
    }

    public Long getEnmonId() 
    {
        return enmonId;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setEnmonDetetime(Date enmonDetetime) 
    {
        this.enmonDetetime = enmonDetetime;
    }

    public Date getEnmonDetetime() 
    {
        return enmonDetetime;
    }
    public void setEnmonPm10(Double enmonPm10) 
    {
        this.enmonPm10 = enmonPm10;
    }

    public Double getEnmonPm10() 
    {
        return enmonPm10;
    }
    public void setEnmonPm10Refer(Double enmonPm10Refer) 
    {
        this.enmonPm10Refer = enmonPm10Refer;
    }

    public Double getEnmonPm10Refer() 
    {
        return enmonPm10Refer;
    }
    public void setEnmonPm25(Double enmonPm25) 
    {
        this.enmonPm25 = enmonPm25;
    }

    public Double getEnmonPm25() 
    {
        return enmonPm25;
    }
    public void setEnmonPm25Refer(Double enmonPm25Refer) 
    {
        this.enmonPm25Refer = enmonPm25Refer;
    }

    public Double getEnmonPm25Refer() 
    {
        return enmonPm25Refer;
    }
    public void setEnmonNoise(Double enmonNoise) 
    {
        this.enmonNoise = enmonNoise;
    }

    public Double getEnmonNoise() 
    {
        return enmonNoise;
    }
    public void setEnmonNoiseRefer(Double enmonNoiseRefer) 
    {
        this.enmonNoiseRefer = enmonNoiseRefer;
    }

    public Double getEnmonNoiseRefer() 
    {
        return enmonNoiseRefer;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("enmonId", getEnmonId())
            .append("eninfoId", getEninfoId())
            .append("enmonDetetime", getEnmonDetetime())
            .append("enmonPm10", getEnmonPm10())
            .append("enmonPm10Refer", getEnmonPm10Refer())
            .append("enmonPm25", getEnmonPm25())
            .append("enmonPm25Refer", getEnmonPm25Refer())
            .append("enmonNoise", getEnmonNoise())
            .append("enmonNoiseRefer", getEnmonNoiseRefer())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
