package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 生产管理-采购订单对象 pro_pur
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class ProPur extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 采购单主键ID */
    private Long purId;

    /** 企业信息主键ID（关联主键） */
    @Excel(name = "企业信息主键ID", readConverterExp = "关=联主键")
    private Long eninfoId;

    /** 订单号 */
    @Excel(name = "订单号")
    private String purOrdernum;

    /** 供货商名称 */
    @Excel(name = "供货商名称")
    private String purSupname;

    /** 采购时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "采购时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date purPurtime;

    /** 合同类型 0xx 1xx 2xx */
    @Excel(name = "合同类型 0xx 1xx 2xx")
    private Integer purContype;

    /** 签订日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "签订日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date purCludetime;

    /** 结算方式 0现金 1支付宝 2微信 3银行卡 */
    @Excel(name = "结算方式 0现金 1支付宝 2微信 3银行卡")
    private Integer purCleanfrom;

    /** 合同电子版 */
    @Excel(name = "合同电子版")
    private String purContract;

    /** 0删除 1保存 */
    @Excel(name = "0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }

    public void setPurId(Long purId) 
    {
        this.purId = purId;
    }

    public Long getPurId() 
    {
        return purId;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setPurOrdernum(String purOrdernum) 
    {
        this.purOrdernum = purOrdernum;
    }

    public String getPurOrdernum() 
    {
        return purOrdernum;
    }
    public void setPurSupname(String purSupname) 
    {
        this.purSupname = purSupname;
    }

    public String getPurSupname() 
    {
        return purSupname;
    }
    public void setPurPurtime(Date purPurtime) 
    {
        this.purPurtime = purPurtime;
    }

    public Date getPurPurtime() 
    {
        return purPurtime;
    }
    public void setPurContype(Integer purContype) 
    {
        this.purContype = purContype;
    }

    public Integer getPurContype() 
    {
        return purContype;
    }
    public void setPurCludetime(Date purCludetime) 
    {
        this.purCludetime = purCludetime;
    }

    public Date getPurCludetime() 
    {
        return purCludetime;
    }
    public void setPurCleanfrom(Integer purCleanfrom) 
    {
        this.purCleanfrom = purCleanfrom;
    }

    public Integer getPurCleanfrom() 
    {
        return purCleanfrom;
    }
    public void setPurContract(String purContract) 
    {
        this.purContract = purContract;
    }

    public String getPurContract() 
    {
        return purContract;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("purId", getPurId())
            .append("eninfoId", getEninfoId())
            .append("purOrdernum", getPurOrdernum())
            .append("purSupname", getPurSupname())
            .append("purPurtime", getPurPurtime())
            .append("purContype", getPurContype())
            .append("purCludetime", getPurCludetime())
            .append("purCleanfrom", getPurCleanfrom())
            .append("purContract", getPurContract())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
