package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 生产管理-采购订单-采购明细对象 pro_pur_pdet
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class ProPurPdet extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 采购明细主键ID */
    private Long pdetId;

    /** 采购单主键ID */
    @Excel(name = "采购单主键ID")
    private Long purId;

    /** 批号 */
    @Excel(name = "批号")
    private String pdetBatchnum;

    /** 原材料 0xx 1xx 2xx */
    @Excel(name = "原材料 0xx 1xx 2xx")
    private Integer pdetRaw;

    /** 品种 */
    @Excel(name = "品种")
    private String pdetVar;

    /** 规格 */
    @Excel(name = "规格")
    private String pdetModel;

    /** 质量 */
    @Excel(name = "质量")
    private String pdetQuality;

    /** 质量证明书编号 */
    @Excel(name = "质量证明书编号")
    private String pdetQuboxnum;

    /** 采购数量 */
    @Excel(name = "采购数量")
    private Integer pdetPurnums;

    /** 生产商 */
    @Excel(name = "生产商")
    private String pdetManu;

    /** 运输商 */
    @Excel(name = "运输商")
    private String pdetForwar;

    /** 有效期限 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "有效期限", width = 30, dateFormat = "yyyy-MM-dd")
    private Date pdetPerofvatime;

    /** 0删除 1保存 */
    @Excel(name = "0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }

    public void setPdetId(Long pdetId) 
    {
        this.pdetId = pdetId;
    }

    public Long getPdetId() 
    {
        return pdetId;
    }
    public void setPurId(Long purId) 
    {
        this.purId = purId;
    }

    public Long getPurId() 
    {
        return purId;
    }
    public void setPdetBatchnum(String pdetBatchnum) 
    {
        this.pdetBatchnum = pdetBatchnum;
    }

    public String getPdetBatchnum() 
    {
        return pdetBatchnum;
    }
    public void setPdetRaw(Integer pdetRaw) 
    {
        this.pdetRaw = pdetRaw;
    }

    public Integer getPdetRaw() 
    {
        return pdetRaw;
    }
    public void setPdetVar(String pdetVar) 
    {
        this.pdetVar = pdetVar;
    }

    public String getPdetVar() 
    {
        return pdetVar;
    }
    public void setPdetModel(String pdetModel) 
    {
        this.pdetModel = pdetModel;
    }

    public String getPdetModel() 
    {
        return pdetModel;
    }
    public void setPdetQuality(String pdetQuality) 
    {
        this.pdetQuality = pdetQuality;
    }

    public String getPdetQuality() 
    {
        return pdetQuality;
    }
    public void setPdetQuboxnum(String pdetQuboxnum) 
    {
        this.pdetQuboxnum = pdetQuboxnum;
    }

    public String getPdetQuboxnum() 
    {
        return pdetQuboxnum;
    }
    public void setPdetPurnums(Integer pdetPurnums) 
    {
        this.pdetPurnums = pdetPurnums;
    }

    public Integer getPdetPurnums() 
    {
        return pdetPurnums;
    }
    public void setPdetManu(String pdetManu) 
    {
        this.pdetManu = pdetManu;
    }

    public String getPdetManu() 
    {
        return pdetManu;
    }
    public void setPdetForwar(String pdetForwar) 
    {
        this.pdetForwar = pdetForwar;
    }

    public String getPdetForwar() 
    {
        return pdetForwar;
    }
    public void setPdetPerofvatime(Date pdetPerofvatime) 
    {
        this.pdetPerofvatime = pdetPerofvatime;
    }

    public Date getPdetPerofvatime() 
    {
        return pdetPerofvatime;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("pdetId", getPdetId())
            .append("purId", getPurId())
            .append("pdetBatchnum", getPdetBatchnum())
            .append("pdetRaw", getPdetRaw())
            .append("pdetVar", getPdetVar())
            .append("pdetModel", getPdetModel())
            .append("pdetQuality", getPdetQuality())
            .append("pdetQuboxnum", getPdetQuboxnum())
            .append("pdetPurnums", getPdetPurnums())
            .append("pdetManu", getPdetManu())
            .append("pdetForwar", getPdetForwar())
            .append("pdetPerofvatime", getPdetPerofvatime())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
