package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 生产管理-生产记录对象 pro_record
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class ProRecord extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 生产记录主键ID */
    private Long recordId;

    /** 生产任务主键ID */
    @Excel(name = "生产任务主键ID")
    private Long todoId;

    /** 搅拌站主键ID */
    @Excel(name = "搅拌站主键ID")
    private Long miplantId;

    /** 实际生产数量 */
    @Excel(name = "实际生产数量")
    private Long recordPracnums;

    /** 实际开盘时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "实际开盘时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date recordPrastarttime;

    /** 实际结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "实际结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date recordPraendtime;

    /** 配比执行状况 */
    @Excel(name = "配比执行状况")
    private String recordMatchexecute;

    /** 计量误差 */
    @Excel(name = "计量误差")
    private String recordMetererro;

    /** 责任人 */
    @Excel(name = "责任人")
    private String recordChaperson;

    /** 状态 0删除 1保存 */
    @Excel(name = "状态 0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    /** 生产任务单号 */
    @Excel(name = "生产任务单号")
    private String todoNumbers;
    
    /** 搅拌站名称 */
    @Excel(name = "搅拌站名称")
    private String miplantName;
    
    
    public String getTodoNumbers() {
		return todoNumbers;
	}

	public void setTodoNumbers(String todoNumbers) {
		this.todoNumbers = todoNumbers;
	}

	public String getMiplantName() {
		return miplantName;
	}

	public void setMiplantName(String miplantName) {
		this.miplantName = miplantName;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }

    public void setRecordId(Long recordId) 
    {
        this.recordId = recordId;
    }

    public Long getRecordId() 
    {
        return recordId;
    }
    public void setTodoId(Long todoId) 
    {
        this.todoId = todoId;
    }

    public Long getTodoId() 
    {
        return todoId;
    }
    public void setMiplantId(Long miplantId) 
    {
        this.miplantId = miplantId;
    }

    public Long getMiplantId() 
    {
        return miplantId;
    }
    public void setRecordPracnums(Long recordPracnums) 
    {
        this.recordPracnums = recordPracnums;
    }

    public Long getRecordPracnums() 
    {
        return recordPracnums;
    }
    public void setRecordPrastarttime(Date recordPrastarttime) 
    {
        this.recordPrastarttime = recordPrastarttime;
    }

    public Date getRecordPrastarttime() 
    {
        return recordPrastarttime;
    }
    public void setRecordPraendtime(Date recordPraendtime) 
    {
        this.recordPraendtime = recordPraendtime;
    }

    public Date getRecordPraendtime() 
    {
        return recordPraendtime;
    }
    public void setRecordMatchexecute(String recordMatchexecute) 
    {
        this.recordMatchexecute = recordMatchexecute;
    }

    public String getRecordMatchexecute() 
    {
        return recordMatchexecute;
    }
    public void setRecordMetererro(String recordMetererro) 
    {
        this.recordMetererro = recordMetererro;
    }

    public String getRecordMetererro() 
    {
        return recordMetererro;
    }
    public void setRecordChaperson(String recordChaperson) 
    {
        this.recordChaperson = recordChaperson;
    }

    public String getRecordChaperson() 
    {
        return recordChaperson;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("recordId", getRecordId())
            .append("todoId", getTodoId())
            .append("miplantId", getMiplantId())
            .append("recordPracnums", getRecordPracnums())
            .append("recordPrastarttime", getRecordPrastarttime())
            .append("recordPraendtime", getRecordPraendtime())
            .append("recordMatchexecute", getRecordMatchexecute())
            .append("recordMetererro", getRecordMetererro())
            .append("recordChaperson", getRecordChaperson())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
