package com.ruoyi.project.cmplant.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 生产管理-生产记录-原材料清单对象 pro_record_rawdet
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class ProRecordRawdet extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** $column.columnComment */
    private Long rawdetId;

    /** 生产记录主键ID */
    @Excel(name = "生产记录主键ID")
    private Long recordId;

    /** 原材料名称 cement水泥 water水 sand砂 stone石 flyash粉煤灰 additive外加剂 swell膨胀剂 */
    @Excel(name = "原材料名称 cement水泥 water水 sand砂 stone石 flyash粉煤灰 additive外加剂 swell膨胀剂")
    private Integer rawdetName;

    /** 批次 */
    @Excel(name = "批次")
    private String rawdetBatch;

    /** 品牌 */
    @Excel(name = "品牌")
    private String rawdetBrand;

    /** 供应商 */
    @Excel(name = "供应商")
    private String rawdetSupplier;

    /** 状态 0删除 1保存 */
    @Excel(name = "状态 0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }

    public void setRawdetId(Long rawdetId) 
    {
        this.rawdetId = rawdetId;
    }

    public Long getRawdetId() 
    {
        return rawdetId;
    }
    public void setRecordId(Long recordId) 
    {
        this.recordId = recordId;
    }

    public Long getRecordId() 
    {
        return recordId;
    }
    public void setRawdetName(Integer rawdetName) 
    {
        this.rawdetName = rawdetName;
    }

    public Integer getRawdetName() 
    {
        return rawdetName;
    }
    public void setRawdetBatch(String rawdetBatch) 
    {
        this.rawdetBatch = rawdetBatch;
    }

    public String getRawdetBatch() 
    {
        return rawdetBatch;
    }
    public void setRawdetBrand(String rawdetBrand) 
    {
        this.rawdetBrand = rawdetBrand;
    }

    public String getRawdetBrand() 
    {
        return rawdetBrand;
    }
    public void setRawdetSupplier(String rawdetSupplier) 
    {
        this.rawdetSupplier = rawdetSupplier;
    }

    public String getRawdetSupplier() 
    {
        return rawdetSupplier;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("rawdetId", getRawdetId())
            .append("recordId", getRecordId())
            .append("rawdetName", getRawdetName())
            .append("rawdetBatch", getRawdetBatch())
            .append("rawdetBrand", getRawdetBrand())
            .append("rawdetSupplier", getRawdetSupplier())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
