package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 生产管理-销售订单对象 pro_sales
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class ProSales extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 销售订单主键ID */
    private Long salesId;

    /** 企业信息主键ID（关联主键） */
    @Excel(name = "企业信息主键ID", readConverterExp = "关=联主键")
    private Long eninfoId;

    /** 销售订单号 */
    @Excel(name = "销售订单号")
    private String salesOrdernum;

    /** 需方企业名称 */
    @Excel(name = "需方企业名称")
    private String salesDemname;

    /** 需方统一社会信用代码 */
    @Excel(name = "需方统一社会信用代码")
    private String salesSccode;

    /** 工程编号 */
    @Excel(name = "工程编号")
    private String salesJobnum;

    /** 工程名称 */
    @Excel(name = "工程名称")
    private String salesJobname;

    /** 工程类型 0其他 1房建 2市政 3交通 */
    @Excel(name = "工程类型 0其他 1房建 2市政 3交通")
    private String salesJobtype;

    /** 工程地址 */
    @Excel(name = "工程地址")
    private String salesJobaddr;

    /** 工程经度 */
    @Excel(name = "工程经度")
    private Double salesJoblon;

    /** 工程纬度 */
    @Excel(name = "工程纬度")
    private Double salesJonlat;

    /** 工程开始时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "工程开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date salesJobstarttime;

    /** 工程结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "工程结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date salesJobendtime;

    /** 混泥土强度 */
    @Excel(name = "混泥土强度")
    private String salesStrenth;

    /** 单价 */
    @Excel(name = "单价")
    private Long salesUnitprice;

    /** 数量 */
    @Excel(name = "数量")
    private Integer salesNums;

    /** 合同附件 */
    @Excel(name = "合同附件")
    private String salesAppendix;

    /** 0删除 1保存 */
    @Excel(name = "0删除 1保存")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    
    
    public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }

    public void setSalesId(Long salesId) 
    {
        this.salesId = salesId;
    }

    public Long getSalesId() 
    {
        return salesId;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setSalesOrdernum(String salesOrdernum) 
    {
        this.salesOrdernum = salesOrdernum;
    }

    public String getSalesOrdernum() 
    {
        return salesOrdernum;
    }
    public void setSalesDemname(String salesDemname) 
    {
        this.salesDemname = salesDemname;
    }

    public String getSalesDemname() 
    {
        return salesDemname;
    }
    public void setSalesSccode(String salesSccode) 
    {
        this.salesSccode = salesSccode;
    }

    public String getSalesSccode() 
    {
        return salesSccode;
    }
    public void setSalesJobnum(String salesJobnum) 
    {
        this.salesJobnum = salesJobnum;
    }

    public String getSalesJobnum() 
    {
        return salesJobnum;
    }
    public void setSalesJobname(String salesJobname) 
    {
        this.salesJobname = salesJobname;
    }

    public String getSalesJobname() 
    {
        return salesJobname;
    }
    public void setSalesJobtype(String salesJobtype) 
    {
        this.salesJobtype = salesJobtype;
    }

    public String getSalesJobtype() 
    {
        return salesJobtype;
    }
    public void setSalesJobaddr(String salesJobaddr) 
    {
        this.salesJobaddr = salesJobaddr;
    }

    public String getSalesJobaddr() 
    {
        return salesJobaddr;
    }
    public void setSalesJoblon(Double salesJoblon) 
    {
        this.salesJoblon = salesJoblon;
    }

    public Double getSalesJoblon() 
    {
        return salesJoblon;
    }
    public void setSalesJonlat(Double salesJonlat) 
    {
        this.salesJonlat = salesJonlat;
    }

    public Double getSalesJonlat() 
    {
        return salesJonlat;
    }
    public void setSalesJobstarttime(Date salesJobstarttime) 
    {
        this.salesJobstarttime = salesJobstarttime;
    }

    public Date getSalesJobstarttime() 
    {
        return salesJobstarttime;
    }
    public void setSalesJobendtime(Date salesJobendtime) 
    {
        this.salesJobendtime = salesJobendtime;
    }

    public Date getSalesJobendtime() 
    {
        return salesJobendtime;
    }
    public void setSalesStrenth(String salesStrenth) 
    {
        this.salesStrenth = salesStrenth;
    }

    public String getSalesStrenth() 
    {
        return salesStrenth;
    }
    public void setSalesUnitprice(Long salesUnitprice) 
    {
        this.salesUnitprice = salesUnitprice;
    }

    public Long getSalesUnitprice() 
    {
        return salesUnitprice;
    }
    public void setSalesNums(Integer salesNums) 
    {
        this.salesNums = salesNums;
    }

    public Integer getSalesNums() 
    {
        return salesNums;
    }
    public void setSalesAppendix(String salesAppendix) 
    {
        this.salesAppendix = salesAppendix;
    }

    public String getSalesAppendix() 
    {
        return salesAppendix;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("salesId", getSalesId())
            .append("eninfoId", getEninfoId())
            .append("salesOrdernum", getSalesOrdernum())
            .append("salesDemname", getSalesDemname())
            .append("salesSccode", getSalesSccode())
            .append("salesJobnum", getSalesJobnum())
            .append("salesJobname", getSalesJobname())
            .append("salesJobtype", getSalesJobtype())
            .append("salesJobaddr", getSalesJobaddr())
            .append("salesJoblon", getSalesJoblon())
            .append("salesJonlat", getSalesJonlat())
            .append("salesJobstarttime", getSalesJobstarttime())
            .append("salesJobendtime", getSalesJobendtime())
            .append("salesStrenth", getSalesStrenth())
            .append("salesUnitprice", getSalesUnitprice())
            .append("salesNums", getSalesNums())
            .append("salesAppendix", getSalesAppendix())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
