package com.ruoyi.project.cmplant.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 生产管理-生产任务单对象 pro_todo
 * 
 * @author lihang
 * @date 2020-08-27
 */
public class ProTodo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 生产任务主键ID */
    private Long todoId;

    /** 企业信息主键ID（关联主键） */
    @Excel(name = "企业信息主键ID", readConverterExp = "关=联主键")
    private Long eninfoId;

    /** 生产日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "生产日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date todoTime;

    /** 生产任务单号 */
    @Excel(name = "生产任务单号")
    private String todoNumbers;

    /** 搅拌站主键ID */
    @Excel(name = "搅拌站主键ID")
    private Long miplantId;

    /** 工程名称 */
    @Excel(name = "工程名称")
    private String todoProname;

    /** 浇筑部位 */
    @Excel(name = "浇筑部位")
    private String todoPart;

    /** 配合比 */
    @Excel(name = "配合比")
    private Double todoMatch;

    /** 计划数量 */
    @Excel(name = "计划数量")
    private Integer todoPlannums;

    /** 开盘时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "开盘时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date todoStarttime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date todoEndtime;

    /** 原材料配比详情 */
    @Excel(name = "原材料配比详情")
    private String todoRatiodet;

    /** 任务制定人 */
    @Excel(name = "任务制定人")
    private String todoProducer;

    /** 状态 0删除 1保存 2上报 */
    @Excel(name = "状态 0删除 1保存 2上报")
    private Integer status;
    
    /** 企业名称 */
    @Excel(name = "企业名称")
    private String eninfoName;
    
    /** 行政区划名称 */
    @Excel(name = "行政区划名称")
    private String xzqhmc;
    
    /** 市 */
    @Excel(name = "市")
    private String city;
    
    /** 县 */
    @Excel(name = "县")
    private String county;
    
    /** 搅拌站名称 */
    @Excel(name = "搅拌站名称")
    private String miplantName;
    
    public String getMiplantName() {
		return miplantName;
	}

	public void setMiplantName(String miplantName) {
		this.miplantName = miplantName;
	}

	public String getCity() {
		return city;
	}

	public void setCity(String city) {
		this.city = city;
	}

	public String getCounty() {
		return county;
	}

	public void setCounty(String county) {
		this.county = county;
	}
    
    public void setXzqhmc(String xzqhmc) 
    {
        this.xzqhmc = xzqhmc;
    }

    public String getXzqhmc() 
    {
        return xzqhmc;
    }
    public void setEninfoName(String eninfoName) 
    {
        this.eninfoName = eninfoName;
    }

    public String getEninfoName() 
    {
        return eninfoName;
    }

    public void setTodoId(Long todoId) 
    {
        this.todoId = todoId;
    }

    public Long getTodoId() 
    {
        return todoId;
    }
    public void setEninfoId(Long eninfoId) 
    {
        this.eninfoId = eninfoId;
    }

    public Long getEninfoId() 
    {
        return eninfoId;
    }
    public void setTodoTime(Date todoTime) 
    {
        this.todoTime = todoTime;
    }

    public Date getTodoTime() 
    {
        return todoTime;
    }
    public void setTodoNumbers(String todoNumbers) 
    {
        this.todoNumbers = todoNumbers;
    }

    public String getTodoNumbers() 
    {
        return todoNumbers;
    }
    public void setMiplantId(Long miplantId) 
    {
        this.miplantId = miplantId;
    }

    public Long getMiplantId() 
    {
        return miplantId;
    }
    public void setTodoProname(String todoProname) 
    {
        this.todoProname = todoProname;
    }

    public String getTodoProname() 
    {
        return todoProname;
    }
    public void setTodoPart(String todoPart) 
    {
        this.todoPart = todoPart;
    }

    public String getTodoPart() 
    {
        return todoPart;
    }
    public void setTodoMatch(Double todoMatch) 
    {
        this.todoMatch = todoMatch;
    }

    public Double getTodoMatch() 
    {
        return todoMatch;
    }
    public void setTodoPlannums(Integer todoPlannums) 
    {
        this.todoPlannums = todoPlannums;
    }

    public Integer getTodoPlannums() 
    {
        return todoPlannums;
    }
    public void setTodoStarttime(Date todoStarttime) 
    {
        this.todoStarttime = todoStarttime;
    }

    public Date getTodoStarttime() 
    {
        return todoStarttime;
    }
    public void setTodoEndtime(Date todoEndtime) 
    {
        this.todoEndtime = todoEndtime;
    }

    public Date getTodoEndtime() 
    {
        return todoEndtime;
    }
    public void setTodoRatiodet(String todoRatiodet) 
    {
        this.todoRatiodet = todoRatiodet;
    }

    public String getTodoRatiodet() 
    {
        return todoRatiodet;
    }
    public void setTodoProducer(String todoProducer) 
    {
        this.todoProducer = todoProducer;
    }

    public String getTodoProducer() 
    {
        return todoProducer;
    }
    public void setStatus(Integer status) 
    {
        this.status = status;
    }

    public Integer getStatus() 
    {
        return status;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("todoId", getTodoId())
            .append("eninfoId", getEninfoId())
            .append("todoTime", getTodoTime())
            .append("todoNumbers", getTodoNumbers())
            .append("miplantId", getMiplantId())
            .append("todoProname", getTodoProname())
            .append("todoPart", getTodoPart())
            .append("todoMatch", getTodoMatch())
            .append("todoPlannums", getTodoPlannums())
            .append("todoStarttime", getTodoStarttime())
            .append("todoEndtime", getTodoEndtime())
            .append("todoRatiodet", getTodoRatiodet())
            .append("todoProducer", getTodoProducer())
            .append("status", getStatus())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .append("remark", getRemark())
            .toString();
    }
}
